define("jira/components/pager", ['require'], function (require) {
    "use strict";

    var View = require('jira/components/pager/views/pager');
    var Marionette = require('jira/components/libs/marionette-2.1.0');

    return Marionette.ViewManager.extend({
        _buildSearchResults: function(searchResults) {
            this._destroySearchResults();

            this.searchResults = searchResults;
            this.listenTo(this.searchResults, {
                "select reset": function () {
                    this.getView("view").update(this.searchResults);
                }
            });
        },

        _destroySearchResults: function() {
            if (!this.searchResults) return;

            this.stopListening(this.searchResults);
            delete this.searchResults;
        },

        _buildView: function() {
            this.buildView("view", function () {
                var view = new View({
                    el: this.el
                });
                this.listenTo(view, {
                    "next": function() {
                        this.trigger("next");
                    },
                    "previous": function() {
                        this.trigger("previous");
                    }
                });
                return view;
            });
        },

        initialize: function(options) {
            this.el = options.el;

            this._buildView();
        },

        onDestroy: function() {
            Marionette.ViewManager.prototype.onDestroy.call(this);
            this._destroySearchResults();
        },

        load: function(searchResults) {
            this._buildSearchResults(searchResults);
        },

        update: function(searchResults) {
            this.load(searchResults);
            this.getView("view").update(searchResults);
        },

        show: function(el) {
            this.hideView("view");
            this.showView("view", function () {
                var view = new View({
                    el: el
                });
                this.listenTo(view, {
                    "next": function() {
                        this.trigger("next");
                    },
                    "previous": function() {
                        this.trigger("previous");
                    }
                });
                return view;
            });
        }
    });
});
