AJS.test.require("com.atlassian.jira.jira-issue-nav-components:pager-test", function () {
    "use strict";

    require([
        "jira/components/pager",
        "jira/components/pager/views/pager",
        "jira/components/search/results",
        "jira/components/test-utils/marionettemocker",
        "jira/components/test-utils/mockutils"
    ], function(
        Pager,
        PagerView,
        SearchResults,
        MarionetteMocker,
        MockUtils
    ) {
        module("jira/components/pager", {
            setup: function () {
                this.pagerView = MarionetteMocker.createEventedMock(sinon, PagerView);
                this.searchResults = MarionetteMocker.createEventedMock(sinon, SearchResults);

                var PagerConstructor = MockUtils.requireWithMocks("jira/components/pager", {
                    "jira/components/pager/views/pager": this.pagerView.constructor
                });

                this.pager = new PagerConstructor();
            }
        });

        test("Updating the pager with new searchResults tells the view to use those searchResults", function () {
            this.pager.update(this.searchResults);

            sinon.assert.calledOnce(this.pagerView.update);
            sinon.assert.calledWith(this.pagerView.update, this.searchResults);
        });

        test("Updating the pager with new searchResults tells the pager to listen to those searchResults changes", function () {
            this.pager.update(this.searchResults);
            this.pagerView.update.reset();

            this.searchResults.trigger('select');

            sinon.assert.calledOnce(this.pagerView.update);
            sinon.assert.calledWith(this.pagerView.update, this.searchResults);
        });

    });
});
