define('jira/components/libs/marionette-1.4.1/inlinedialogview', ['require'], function (require) {
    "use strict";

    var _ = require('jira/components/libs/underscore');
    var Marionette = require('jira/components/libs/marionette-1.4.1');
    var ItemView = require('jira/components/libs/marionette-1.4.1/itemview');
    var jQuery = require('jquery');
    var InlineDialog = require("aui/inline-dialog");

    /**
     * @class JIRA.Marionette.InlineDialogView
     * @abstract
     *
     * Wraps a InlineDialog in a Marionette view
     *
     * @extends JIRA.Marionette.InlineDialogView
     */
    return ItemView.extend({

        /**
         * Internal InlineDialog instance.
         * @type {InlineDialog}
         */
        dialog: null,

        /**
         * Template used by this dialog.
         * @type {Function}
         */
        template: jQuery.noop,

        _getDialogOptions: function() {
            // Get dialog options
            var defaultDialogOptions = {
                noBind: true
            };

            var dialogOptions = Marionette.getOption(this, "dialogOptions") || {};
            if (_.isFunction(dialogOptions)) {
                dialogOptions = dialogOptions.apply(this);
            }

            dialogOptions = _.extend({}, defaultDialogOptions, dialogOptions);
            dialogOptions.hideCallback = _.bind(function() {
                this.close();
            }, this);

            return dialogOptions;
        },

        _getTrigger: function() {
            // Get dialog trigger
            var trigger = Marionette.getOption(this, "trigger");
            if (_.isFunction(trigger)) {
                trigger = trigger.apply(this);
            }
            return trigger;
        },

        /**
         * Generates the internal InlineDialog.
         *
         * @returns {InlineDialog} The dialog.
         * @private
         */
        _generateDialog: function() {
            var data = this.serializeData();
            var template = this.getTemplate();
            var dialogOptions = this._getDialogOptions();
            var trigger = this._getTrigger();

            return new InlineDialog(trigger, this.id, function($content, $triggerElement, showPopup) {
                $content.html(template(data));
                showPopup();
            }, dialogOptions);
        },

        /**
         * Main render method.
         *
         * @returns {JIRA.Libs.Marionette.DialogView} This view.
         */
        render: function() {
            this.isClosed = false;

            this.triggerMethod("before:render", this);

            this.dialog = this._generateDialog();
            this.$el = this.dialog;
            this.id = this.dialog.id;
            this.dialog.show();

            this.triggerMethod("render", this);

            return this;
        },

        close: function() {
            if (this.isClosed) {
                return;
            }

            var shouldClose = this.triggerMethod("before:close");
            if (shouldClose === false) {
                return;
            }

            this.dialog.hide();
            this.isClosed = true;

            this.triggerMethod('close');

            // remove the view from the DOM
            this.remove();
        }
    });
});

AJS.namespace("JIRA.Marionette.InlineDialogView", null, require('jira/components/libs/marionette-1.4.1/inlinedialogview'));
