define('jira/components/libs/marionette-1.4.1/compositeview', ['require'], function (require) {
    "use strict";

    var Marionette = require('jira/components/libs/marionette-1.4.1');
    var CollectionView = require('jira/components/libs/marionette-1.4.1/collectionview');
    var ItemView = require('jira/components/libs/marionette-1.4.1/itemview');

    /**
     * @class JIRA.Marionette.CompositeView
     *
     * @extends JIRA.Libs.Marionette.CompositeView
     */
    return Marionette.CompositeView.extend({
        /**
         * Appends an itemView to a collectionView in the specified position
         *
         * This method overwrites Marionette's default. The default implementation always appends
         * the itemView at the end, ignoring the index.
         *
         * See https://github.com/marionettejs/backbone.marionette/blob/master/docs/marionette.collectionview.md#collectionviews-appendhtml
         *
         * @param {JIRA.Libs.Marionette.CollectionView} collectionView This view
         * @param {JIRA.Libs.Marionette.View} itemView View being added
         * @param {number} index Position of the itemView
         */
        appendHtml: function(collectionView, itemView, index) {
            CollectionView.prototype._appendHtmlWithIndex(this.getItemViewContainer(collectionView), itemView, index);
        },

        unwrapTemplate: function() {
            ItemView.prototype.unwrapTemplate.call(this);
        }
    });
});
AJS.namespace("JIRA.Marionette.CompositeView", null, require('jira/components/libs/marionette-1.4.1/compositeview'));
