AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueviewer", "com.atlassian.jira.jira-issue-nav-components:issueviewer-test"], function() {
    "use strict";

    require([
        "jira/components/issueviewer/actions",
        'jquery',
        'jira/util/events',
        'jira/util/events/types',
        'jira/util/events/reasons',
        "jira/components/issueviewer/entities/issue",
        "jira/components/issueviewer/controllers/issue"
    ], function(
        Actions,
        jQuery,
        Events,
        Types,
        Reasons,
        IssueModel,
        IssueController
    ) {
        module("jira/components/issueviewer/views/issue", {
            setup: function() {
                this.el = jQuery("<div class='issue-container'></div>").appendTo("#qunit-fixture");
                this.issueModel = new IssueModel();
                this.issueModel.updateFromEntity(mockIssueJSON);
                this.controller = new IssueController({model: this.issueModel});
                this.controller.setElement(this.el);
                this.controller.createView();
                this.view = this.controller.view;
            },
            teardown: function() {
                this.el.remove();
            }
        });

        //TODO Move to IssueViewBody?
        test("Issue Updated via Editing comment focuses comment", function() {
            this.view.render();


            this.issueModel.update({panels: mockWebPanelsJSON, issue: mockIssueJSON}, {
                reason: {
                    action: Actions.EDIT_COMMENT,
                    meta: {
                        commentId: "10270"
                    }
                }
            });
            ok(this.view.$("#comment-10270").hasClass("focused"));

        });

        function waitForRender(fn) {
            setTimeout(fn, 0);
        }

        asyncTest("Dropdown is closed when view is updated", function () {
            var view = this.view;
            view.render();

            waitForRender(function () {
                var trigger = view.$el.find(".aui-dropdown2-trigger").first();
                var dropdown = view.$el.find("#" + trigger.attr("aria-controls"));

                equal(trigger.hasClass("active"), false);
                equal(dropdown.attr("aria-hidden"), "true");

                trigger.trigger("aui-button-invoke");
                ok(trigger.hasClass("active"));
                equal(dropdown.attr("aria-hidden"), "false");

                view.update({});

                equal(trigger.hasClass("active"), false);
                equal(dropdown.attr("aria-hidden"), "true");

                start();
            }, 0);
        });
    });
});
