AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueviewer", "com.atlassian.jira.jira-issue-nav-components:issueviewer-test"], function() {
    "use strict";

    require([
        "jquery",
        "jira/components/issueviewer/entities/panelsgroup",
        "jira/components/issueviewer/entities/issue",
        "jira/components/issueviewer/controllers/issue"
    ], function(
        jQuery,
        PanelsGroup,
        IssueModel,
        IssueController
    ) {
        module('jira/components/issueviewer/views/issuebody', {
            setup: function() {
                this.el = jQuery("<div></div>");
                this.issuePanelsGroupModel = new PanelsGroup();
                this.issuePanelsGroupModel.update(mockWebPanelsJSON, {editable: true});
                this.issueModel = new IssueModel({entity: mockIssueJSON});
                this.issueModel.setPanels(this.issuePanelsGroupModel);

                this.controller = new IssueController({model: this.issueModel});
                this.controller.setElement(this.el);
            },
            teardown: function() {
                this.el.remove();
            },

            assertHasModules: function(column, moduleIds) {
                var $modules = column.find(".module");
                equal($modules.length, moduleIds.length, "Column has correct number of modules");
                $modules.each(function(i, module) {
                    equal(jQuery(module).attr("id"), moduleIds[i], "Module " + moduleIds[i] + " is correct");
                });
            }
        });

        test("Issue Body View renders all web-panels", function() {
            this.controller.show();
            var $el = this.controller.bodyView.$el;

            var $columns = $el.find(".aui-group .aui-item");
            equal($columns.length, 2, "Correct number of columns rendered");
            var $leftColumn = jQuery($columns[0]);
            this.assertHasModules($leftColumn, ["details-module", "descriptionmodule", "attachmentmodule", "linkingmodule", "activitymodule", "addcomment"]);
            var $rightColumn = jQuery($columns[1]);
            this.assertHasModules($rightColumn, ["peoplemodule", "datesmodule"]);
        });

        test("Issue Body can add and remove web-panels", function() {
            this.controller.show();
            var $el = this.controller.bodyView.$el;

            var $columns = $el.find(".aui-group .aui-item");
            equal($columns.length, 2, "Correct number of columns rendered");
            var $leftColumn = jQuery($columns[0]);
            this.assertHasModules($leftColumn, ["details-module", "descriptionmodule", "attachmentmodule", "linkingmodule", "activitymodule", "addcomment"]);
            var $rightColumn = jQuery($columns[1]);
            this.assertHasModules($rightColumn, ["peoplemodule", "datesmodule"]);

            //now remove the attachment module!
            this.issuePanelsGroupModel.update(mockWebPanelsJSONNoAttachments, {editable: true});
            $columns = $el.find(".aui-group .aui-item");
            equal($columns.length, 2, "Correct number of columns rendered");
            $leftColumn = jQuery($columns[0]);
            this.assertHasModules($leftColumn, ["details-module", "descriptionmodule", "linkingmodule", "activitymodule", "addcomment"]);
            $rightColumn = jQuery($columns[1]);
            this.assertHasModules($rightColumn, ["peoplemodule", "datesmodule"]);

            //now add the timetracking module!
            this.issuePanelsGroupModel.update(mockWebPanelsJSONWithTimeTracking, {editable: true});
            $columns = $el.find(".aui-group .aui-item");
            equal($columns.length, 2, "Correct number of columns rendered");
            $leftColumn = jQuery($columns[0]);
            this.assertHasModules($leftColumn, ["details-module", "descriptionmodule", "linkingmodule", "activitymodule", "addcomment"]);
            $rightColumn = jQuery($columns[1]);
            this.assertHasModules($rightColumn, ["peoplemodule", "datesmodule", "timetracking"]);
        });

        test("Update from change data", function() {
            this.controller.show();
            var $el = this.controller.bodyView.$el;

            var $columns = $el.find(".aui-group .aui-item");
            equal($columns.length, 2, "Correct number of columns rendered");
            var $leftColumn = jQuery($columns[0]);
            this.assertHasModules($leftColumn, ["details-module", "descriptionmodule", "attachmentmodule", "linkingmodule", "activitymodule", "addcomment"]);
            var $rightColumn = jQuery($columns[1]);
            this.assertHasModules($rightColumn, ["peoplemodule", "datesmodule"]);

            var props = {
                editable: true,
                changed: {
                    added: {
                        panels: {
                            leftPanels: [],
                            rightPanels: ["timetracking"],
                            infoPanels: []
                        }
                    },
                    updated: {
                        panels: {
                            leftPanels: ["details-module"],
                            rightPanels: ["peoplemodule"],
                            infoPanels: []
                        }
                    },
                    deleted: {
                        panels: {
                            leftPanels: ["attachmentmodule"],
                            rightPanels: [],
                            infoPanels: []
                        }
                    }
                }
            };

            var newPanels = mockWebPanelsJSONNoAttachments;
            newPanels.rightPanels = mockWebPanelsJSONWithTimeTracking.rightPanels;
            newPanels.leftPanels[0].label = "Details-changed";
            newPanels.rightPanels[0].label = "People-changed";

            this.issuePanelsGroupModel.update(newPanels, props);

            $columns = $el.find(".aui-group .aui-item");
            equal($columns.length, 2, "Correct number of columns rendered");
            $leftColumn = jQuery($columns[0]);
            this.assertHasModules($leftColumn, ["details-module", "descriptionmodule", "linkingmodule", "activitymodule", "addcomment"]);
            $rightColumn = jQuery($columns[1]);
            this.assertHasModules($rightColumn, ["peoplemodule", "datesmodule", "timetracking"]);

            equal($leftColumn.find("#details-module .toggle-title").text(), "Details-changed");
            equal($rightColumn.find("#peoplemodule .toggle-title").text(), "People-changed");
        });
    });
});
