define("jira/components/issueviewer/services/metadataservice", ["require"], function(require){
    "use strict";

    var Meta = require("jira/util/data/meta");
    var _ = require("jira/components/libs/underscore");

    /**
     * @class JIRA.Components.IssueViewer.Services.Metadata
     *
     * This service is responsible from adding/removing metadata about an issue
     *
     * @extends Marionette.Controller
     */
    return {
        /**
         * Removes all the issue meta data such as issue key from AJS.Meta
         *
         * @param {JIRA.Components.IssueViewer.Models.Issue} model Model used to extract the values to remove
         */
        removeIssueMetadata: function(model) {
            var issueEntity = model.getEntity();
            if (issueEntity.metadata) {
                _.each(issueEntity.metadata, function(value, key) {
                    Meta.set(key, null);
                });
            } else if (Meta.get("issue-key")) {
                Meta.set("issue-key", null);
            }
        },

        /**
         * Add all the issue meta data such as issue key into AJS.Meta
         *
         * @param {JIRA.Components.IssueViewer.Models.Issue} model Model used to extract the values to add
         */
        addIssueMetadata: function(model) {
            var issueEntity = model.getEntity();
            _.each(issueEntity.metadata, function(value, key) {
                Meta.set(key, value);
            });
        }
    };

});
