AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueviewer"], function () {
    "use strict";

    require([
        'jquery',
        'backbone',
        'jira/components/issueviewer/analytics/issueopsbar',
        "jira/components/utils/ajshelper"
    ], function (jQuery,
                 Backbone,
                 Analytics,
                 AJSHelper) {

        module('jira/components/issueviewer/analytics/issueopsbar', {
            setup: function () {
                this.sandbox = sinon.sandbox.create();

                this.$el = this.buildFakeOpsbar();
                this.model = new Backbone.Model({id: 'some-id'});
                this.issueOpsbarViewStub = {model: this.model, $el: this.$el};
                this.module = new Analytics(this.issueOpsbarViewStub);

                this.context = AJS.test.mockableModuleContext();
                this.issueContext = "unknown";

                this.context.mock("jira/viewissue/analytics-utils", {
                    context: function() {
                        return this.issueContext;
                    }.bind(this)
                });
            },

            /**
             * Creates fake opsbar that is build from one toolbar button (simple-button) and one trigger button (dropdown-button) with 2 operations (suboperation-1, suboperaton-2)
             * @returns {*}
             */
            buildFakeOpsbar: function () {
                var el = jQuery('<div>');
                var menus = jQuery('<div>').addClass('ops-menus');
                el.append(menus);

                var button = jQuery('<ul>');
                button.append(jQuery('<li>').addClass('toolbar-item').
                    append(jQuery('<a>').attr({id: 'simple-button'})));
                menus.append(button);

                var dropdown = jQuery('<ul>');
                dropdown.append(jQuery('<li>').addClass('toolbar-item').addClass('toolbar-dropdown').
                    append(jQuery('<a>').attr({id: 'dropdown-button'}).addClass('toolbar-trigger')));
                menus.append(dropdown);

                var list = jQuery('<li>').append('<div>').addClass('aui-list');
                list.append(jQuery('<a>').attr({id: 'suboperation-1'}));
                list.append(jQuery('<a>').attr({id: 'suboperation-2'}));
                dropdown.find('li').append(list);

                el.appendTo('#qunit-fixture');

                return el;
            },

            teardown: function () {
                this.sandbox.restore();
            }
        });

        test("Analytics are fired on simple button click", function () {
            this.spy(AJSHelper, "trigger");

            var button = this.$el.find('#simple-button');
            button.click();

            sinon.assert.calledOnce(AJSHelper.trigger);
            sinon.assert.calledWith(AJSHelper.trigger, 'analyticsEvent', {
                name: "kickass.opsbar.operation",
                data: {
                    issueId: 'some-id',
                    id: 'simple-button',
                    idx: 0,
                    context: 'unknown'
                }
            });
        });

        test("Analytics are fired on dropdown button click", function () {
            this.spy(AJSHelper, "trigger");

            var button = this.$el.find('#suboperation-2');
            button.click();

            sinon.assert.calledOnce(AJSHelper.trigger);
            sinon.assert.calledWith(AJSHelper.trigger, 'analyticsEvent', {
                name: "kickass.opsbar.operation",
                data: {
                    issueId: 'some-id',
                    id: 'suboperation-2',
                    idx: 1,
                    context: 'unknown',
                    parentId: 'dropdown-button',
                    parentIdx: 1
                }
            });
        });
    });

});
