define("jira/components/issueviewer/utils", ["require"], function(require){
    "use strict";

    var InlineDialog = require('aui/inline-dialog');
    var InlineLayer = require('jira/ajs/layer/inline-layer');
    var jQuery = require("jquery");

    return {
        /**
         * Hides the Fancybox overlay that we use for image attachments, viewing a workflow, etc.
         */
        hideLightbox: function() {
            jQuery.fancybox.close();
        },

        /**
         * Hides any visible drop down on the page
         */
        hideDropdown: function() {
            //HACK: Having a whitelist of dialogs that should not be closed is a maintenance nightmare,
            //but a better solution will involve refactoring AJS.InlineDialog and possibly a change of its
            //architecture/API. Related to JRADEV-21760
            if (InlineDialog.current && InlineDialog.current.id !== "column-picker-dialog") {
                InlineDialog.current.hide();
            }
            if (InlineLayer.current) {
                var $trigger = InlineLayer.current.options.offsetTarget();
                if ($trigger instanceof jQuery) {
                    if (!$trigger.is(":visible")) {
                        InlineLayer.current.hide();
                    }
                }

            }
        }
    };
});
