define("jira/components/issueviewer/appmodule", ["require"], function(require){
    "use strict";

    var _ = require("jira/components/libs/underscore");
    var IssueViewer = require("jira/components/issueviewer");
    var MariontteAppModule = require("jira/components/libs/marionette-1.4.1/appmodule");

    return MariontteAppModule.extend({
        name: "issueViewer",
        generateMasterRequest: true,

        create: function(options) {
            options = _.defaults({}, options, {
                showReturnToSearchOnError: function() {
                    return false;
                }
            });

            return new IssueViewer({
                showReturnToSearchOnError: options.showReturnToSearchOnError
            });
        },

        commands: function() {
            return {
                abortPending: true,
                beforeHide: true,
                beforeShow: true,
                removeIssueMetadata: true,
                updateIssueWithQuery: true,
                close: true,
                setContainer: true,
                dismiss: true
            };
        },

        requests: function() {
            return {
                loadIssue: true,
                canDismissComment: true,
                getIssueId: true,
                getIssueKey: true,
                refreshIssue: true,
                isCurrentlyLoading: true
            };
        },

        events: function() {
            return [
                "loadComplete",
                "loadError",
                "close",
                "render",
                "replacedFocusedPanel",
                "linkToIssue",
                "refineViewer"
            ];
        }
    });

});
