AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueviewer", "com.atlassian.jira.jira-issue-nav-components:issueviewer-test"], function() {
    "use strict";

    require([
        "jira/components/issueviewer",
        "jira/components/issueviewer/appmodule",
        "jira/components/testutils/app-module"
    ], function(
        IssueViewer,
        AppModule,
        TestUtilsAppModule
    ) {
        module('jira/components/issueviewer/appmodule', {
            setup: function() {
                this.sandbox = sinon.sandbox.create();
                this.application = TestUtilsAppModule.startApplication();
            },

            createModule: function() {
                return TestUtilsAppModule.createAMDModule({
                    sinon: this.sandbox,
                    application: this.application,
                    appModuleName: "jira/components/issueviewer/appmodule",
                    moduleName: "jira/components/issueviewer"
                });
            },

            stubMethods: function(methods) {
                TestUtilsAppModule.stubMethods({
                    sinon: this.sandbox,
                    methods: methods,
                    moduleClass: IssueViewer
                });
            },

            teardown: function() {
                this.sandbox.restore();
                this.application.stop();
                delete this.application;
            }
        });

        test("It creates a instance of IssueViewer", function() {
            var appModule = new AppModule();
            ok(appModule.create() instanceof IssueViewer, "Initialize creates a instance of IssueViewer");
        });

        test("Commands are registered in the application", function() {
            var commands = [
                "abortPending",
                "beforeHide",
                "beforeShow",
                "removeIssueMetadata",
                "updateIssueWithQuery",
                "close",
                "setContainer",
                "dismiss"
            ];

            this.stubMethods(commands);
            TestUtilsAppModule.assertCommands({
                commands: commands,
                commandsNamespace: "issueViewer",
                application: this.application,
                module: this.createModule()
            });
        });

        test("Requests are registered in the application", function() {
            var requests = [
                "loadIssue",
                "canDismissComment",
                "getIssueId",
                "getIssueKey",
                "refreshIssue",
                "isCurrentlyLoading"
            ];

            this.stubMethods(requests);
            TestUtilsAppModule.assertRequests({
                requests: requests,
                requestsNamespace: "issueViewer",
                application: this.application,
                module: this.createModule()
            });
        });

        test("Events are registered in the application", function() {
            var events = [
                "loadComplete",
                "loadError",
                "close",
                "replacedFocusedPanel"
            ];
            TestUtilsAppModule.assertEvents({
                events: events,
                sinon: this.sandbox,
                application: this.application,
                eventsNamespace: "issueViewer",
                module: this.createModule()
            });
        });
    });
});
