define("jira/components/analytics/appmodule", ['require'], function (require) {
    "use strict";

    var MarionetteAppModule = require('jira/components/libs/marionette-1.4.1/appmodule');
    var _ = require('jira/components/libs/underscore');
    var Analytics = require('jira/components/analytics');

    return MarionetteAppModule.extend({
        name: "analytics",
        generateMasterRequest: true,

        /**
         * @param {Object} options Options object
         * @param {boolean} [options.useLog=false] Whether this module should log events using AJS.log()
         */
        create: function(options) {
            options = _.defaults({}, options, {
                useLog: false
            });

            return new Analytics(options);
        },

        commands: {
            trigger: true,
            registerEvent: true,
            registerTracker: true
        }
    });
});
