define("jira/components/issueeditor/appmodule", ["require"], function(require){
    "use strict";

    var _ = require("jira/components/libs/underscore");
    var IssueEditor = require("jira/components/issueeditor");
    var IssueViewerAppModule = require("jira/components/issueviewer/appmodule");

    return IssueViewerAppModule.extend({
        name: "issueEditor",
        generateMasterRequest: true,

        create: function(options) {
            options = _.defaults({}, options, {
                showReturnToSearchOnError: function() {
                    return false;
                }
            });

            return new IssueEditor({
                showReturnToSearchOnError: options.showReturnToSearchOnError
            });
        },

        commands: function(module) {
            var viewerCommands = IssueViewerAppModule.prototype.commands.call(this, module);
            return _.extend(viewerCommands, {
                "editField": true
            });
        },

        requests: function(module) {
            var viewerRequests = IssueViewerAppModule.prototype.requests.call(this, module);
            return _.extend(viewerRequests, {
                "fields": function() {
                    return module.getFields();
                },
                "hasSavesInProgress": true
            });
        },

        events: function(module) {
            var viewerEvents = IssueViewerAppModule.prototype.events.call(this, module);

            return viewerEvents.concat([
                "saveSuccess",
                "saveError",
                "editField",
                "editFieldCancel",
                "fieldSubmitted",
                "fieldsLoaded"
            ]);
        }
    });
});
