AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueeditor", "com.atlassian.jira.jira-issue-nav-components:issueeditor-test"], function() {
    "use strict";

    require([
        "jira/components/issueeditor",
        "jira/components/issueeditor/appmodule",
        "jira/components/testutils/app-module"
    ], function(
        IssueEditor,
        AppModule,
        TestUtilsAppModule
    ) {
        module('jira/components/issueeditor/appmodule', {
            setup: function() {
                this.sandbox = sinon.sandbox.create();
                this.application = TestUtilsAppModule.startApplication();
            },

            createModule: function() {
                return TestUtilsAppModule.createAMDModule({
                    sinon: this.sandbox,
                    application: this.application,
                    appModuleName: "jira/components/issueeditor/appmodule",
                    moduleName: "jira/components/issueeditor"
                });
            },

            stubMethods: function(methods) {
                TestUtilsAppModule.stubMethods({
                    sinon: this.sandbox,
                    methods: methods,
                    moduleClass: IssueEditor
                });
            },

            teardown: function() {
                this.sandbox.restore();
                this.application.stop();
                delete this.application;
            }
        });

        test("It creates a instance of IssueEditor", function() {
            var appModule = new AppModule();
            ok(appModule.create() instanceof IssueEditor, "Initialize creates a instance of IssueEditor");
        });

        test("Commands are registered in the application", function() {
            var commands = [
                "abortPending",
                "beforeHide",
                "beforeShow",
                "removeIssueMetadata",
                "updateIssueWithQuery",
                "close",
                "setContainer",
                "dismiss",
                "editField"
            ];

            this.stubMethods(commands);
            TestUtilsAppModule.assertCommands({
                commands: commands,
                commandsNamespace: "issueEditor",
                application: this.application,
                module: this.createModule()
            });
        });

        test("Requests are registered in the application", function() {
            var requests = [
                "loadIssue",
                "canDismissComment",
                "getIssueId",
                "getIssueKey",
                "refreshIssue",
                "isCurrentlyLoading"
            ];

            this.stubMethods(requests);
            var module = this.createModule();
            TestUtilsAppModule.assertRequests({
                requests: requests,
                requestsNamespace: "issueEditor",
                application: this.application,
                module: module
            });

            // We need to test this request manually because the module method (getField) does not match the request
            // (fields)
            this.stubMethods(["getFields"]);
            this.application.request("issueEditor:fields");
            ok(module.getFields.calledOnce, "The request 'fields' calls the method 'getFields'");
        });

        test("Events are registered in the application", function() {
            var events = [
                "loadComplete",
                "loadError",
                "close",
                "replacedFocusedPanel",
                "saveSuccess",
                "saveError",
                "fieldSubmitted",
                "editField",
                "editFieldCancel"
            ];
            TestUtilsAppModule.assertEvents({
                events: events,
                sinon: this.sandbox,
                application: this.application,
                eventsNamespace: "issueEditor",
                module: this.createModule()
            });
        });
    });
});
