AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueeditor", "com.atlassian.jira.jira-issue-nav-components:issueeditor-test"], function() {
    "use strict";

    require([
        "jquery",
        'jira/util/events',
        "jira/components/issueeditor/eventtypes",
        "jira/components/issueeditor/inlineeditutils"
    ], function(
        jQuery,
        Events,
        EventTypes,
        InlineEditUtils
    ) {
        module('jira/components/issueeditor/inlineeditutils', {

            setup: function() {
                this.$randomInput = jQuery("<input />").appendTo("#qunit-fixture");
                this.$elContainer = jQuery("<div>").appendTo("#qunit-fixture");
                this.$el = jQuery("<div>").appendTo(this.$elContainer);
            },

            teardown: function() {
                this.$el.remove();
                this.$randomInput.remove();
            }

        });

        test("Blur triggers INLINE_EDIT_BLURRED", function() {
            var clock = sinon.useFakeTimers();
            var $input = jQuery("<input />").appendTo(this.$el).focus();
            Events.trigger(EventTypes.INLINE_EDIT_STARTED, ["priority", null, this.$el, this.$elContainer]);

            var spy = sinon.spy();
            Events.bind(EventTypes.INLINE_EDIT_BLURRED, spy);
            $input.blur();
            clock.tick(InlineEditUtils.BLUR_FOCUS_TIMEOUT + 1);

            equal(spy.callCount, 1);
            equal(spy.args[0][1], "priority");
            clock.restore();
        });

        test("INLINE_EDIT_BLURRED is triggered when input is root element", function() {
            var clock = sinon.useFakeTimers();
            var $input = jQuery("<input>").appendTo(this.$el).focus();
            Events.trigger(EventTypes.INLINE_EDIT_STARTED, ["priority", null, $input, this.$elContainer]);

            var spy = sinon.spy();
            Events.bind(EventTypes.INLINE_EDIT_BLURRED, spy);
            $input.blur();
            clock.tick(InlineEditUtils.BLUR_FOCUS_TIMEOUT + 1);

            equal(spy.callCount, 1);
            equal(spy.args[0][1], "priority");
            clock.restore();
        });

        test("INLINE_EDIT_BLURRED is NOT triggered when switching between inputs in same field", function() {
            var clock = sinon.useFakeTimers();
            var $inputA = jQuery("<input>").appendTo(this.$el);
            var $inputB = jQuery("<input>").appendTo(this.$el);
            Events.trigger(EventTypes.INLINE_EDIT_STARTED, ["priority", null, this.$el, this.$elContainer]);
            $inputA.focus();

            var spy = sinon.spy();
            Events.bind(EventTypes.INLINE_EDIT_BLURRED, spy);
            $inputA.blur();
            $inputB.focus();
            clock.tick(InlineEditUtils.BLUR_FOCUS_TIMEOUT + 1);

            equal(spy.callCount, 0);
            clock.restore();
        });

        test("INLINE_EDIT_BLURRED is triggered when all inputs in field are blurred", function() {
            var clock = sinon.useFakeTimers();
            var $container = jQuery("<div>").appendTo(this.$el);
            var $inputA = jQuery("<input>").appendTo($container);
            var $inputB = jQuery("<input>").appendTo($container);

            Events.trigger(EventTypes.INLINE_EDIT_STARTED, ["priority", null, $container, this.$elContainer]);
            $inputA.focus();

            var spy = sinon.spy();
            Events.bind(EventTypes.INLINE_EDIT_BLURRED, spy);
            $inputA.blur();
            $inputB.focus();
            $inputB.blur();
            clock.tick(InlineEditUtils.BLUR_FOCUS_TIMEOUT + 1);

            equal(spy.callCount, 1);
            equal(spy.args[0][1], "priority");
            clock.restore();
        });

        test("INLINE_EDIT_BLURRED is NOT triggered when inputs are blurred, but container has focus", function() {
            var clock = sinon.useFakeTimers();
            var $container = jQuery("<div>").appendTo(this.$el);
            var $input = jQuery('<input>').appendTo($container);

            Events.trigger(EventTypes.INLINE_EDIT_STARTED, ["priority", null, $container, this.$elContainer]);
            $input.focus();

            var spy = sinon.spy();
            Events.bind(EventTypes.INLINE_EDIT_BLURRED, spy);
            $input.blur();
            $container.focus();
            clock.tick(InlineEditUtils.BLUR_FOCUS_TIMEOUT + 1);

            equal(spy.callCount, 0);
            clock.restore();
        });

        test("INLINE_EDIT_BLURRED handlers are called with appropriate fieldId argument", function() {
            var clock = sinon.useFakeTimers();
            var $inputA = jQuery("<input>").appendTo(this.$el);
            var $inputB = jQuery("<input>").appendTo(this.$el);

            var spyFocused = sinon.spy();
            var spyBlurred = sinon.spy();

            Events.bind(EventTypes.INLINE_EDIT_FOCUSED, spyFocused);
            Events.bind(EventTypes.INLINE_EDIT_BLURRED, spyBlurred);

            Events.trigger(EventTypes.INLINE_EDIT_STARTED, ["summary", null, $inputA, this.$elContainer]);
            $inputA.focus();
            $inputA.blur();

            Events.trigger(EventTypes.INLINE_EDIT_STARTED, ["priority", null, $inputB, this.$elContainer]);
            $inputB.focus();
            $inputB.blur();

            clock.tick(InlineEditUtils.BLUR_FOCUS_TIMEOUT + 1);

            equal(spyFocused.getCall(0).args[1], "summary", "Focused field is identified correctly");
            equal(spyBlurred.getCall(0).args[1], "summary", "Blurred field is identified correctly");

            equal(spyFocused.getCall(1).args[1], "priority", "Focused field is identified correctly");
            equal(spyBlurred.getCall(1).args[1], "priority", "Blurred field is identified correctly");
            clock.restore();
        });

        test("jira/components/issueeditor/inlineeditutils#BlurTriggers is exposed as JIRA.Issues.InlineEdit.BlurTriggers", function() {
            // See https://jira.atlassian.com/browse/JRA-40478
            equal(InlineEditUtils.BlurTriggers, JIRA.Issues.InlineEdit.BlurTriggers);
        });

        test("jira/components/issueeditor/inlineeditutils#BlurTriggerMapping is exposed as JIRA.Issues.InlineEdit.BlurTriggerMapping", function() {
            // See https://jira.atlassian.com/browse/JRA-40478
            equal(InlineEditUtils.BlurTriggerMapping, JIRA.Issues.InlineEdit.BlurTriggerMapping);
        });
    });
});
