AJS.test.require("com.atlassian.jira.jira-issue-nav-components:issuecomponentresolver-test", function() {
    "use strict";

    var IssueComponentResolver = require('jira/components/issuecomponentresolver');
    var InlineEditParams = require('jira/components/util/inlineeditparams');
    var IssueViewer = require('jira/components/issueviewer');
    var IssueEditor = require('jira/components/issueeditor');

    module("jira/components/issuecomponentresolver", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(InlineEditParams, 'isEnabled');
        },
        teardown: function() {
            this.sandbox.restore();
        },
        enableInlineEdit: function() {
            InlineEditParams.isEnabled.returns(true);
        },
        disableInlineEdit: function() {
            InlineEditParams.isEnabled.returns(false);
        }
    });

    test("resolves IssueViewer when Inline Edit is disabled", function() {
        this.disableInlineEdit();

        var resolved = IssueComponentResolver.resolve();

        equal(IssueViewer, resolved);
    });

    test("resolves IssueEditor when Inline Edit is enabled", function() {
        this.enableInlineEdit();

        var resolved = IssueComponentResolver.resolve();

        equal(IssueEditor, resolved);
    });
});
