AJS.test.require("com.atlassian.jira.jira-issue-nav-components:inline-issue-create-test", function() {
    "use strict";

    require([
        "jira/components/test-utils/mockutils",
        "jira/components/test-utils/marionettemocker",
        "jira/inline-issue-create/widget",
        "jira/inline-issue-create/views/default-trigger",
        "jira/inline-issue-create/entities/inline-bootstrap",
        "jquery"
    ], function(
        MockUtils,
        MarionetteMocker,
        IicWidget,
        IicTrigger,
        IicBootstrap,
        jQuery
    ) {

        module("jira/components/inline-issue-create", {
            setup: function() {
                this.IicWidget = MarionetteMocker.createEventedMock(sinon, IicWidget);
                this.IicTrigger = MarionetteMocker.createEventedMock(sinon, IicTrigger);
                this.IicBootstrap = MarionetteMocker.createEventedMock(sinon, IicBootstrap);
                this.IicBootstrap.projects = ["non-empty-list"];

                this.InlineIssueCreateConstructor = MockUtils.requireWithMocks("jira/components/inline-issue-create", {
                    "jira/inline-issue-create/widget": this.IicWidget.constructor,
                    "jira/inline-issue-create/views/default-trigger": this.IicTrigger.constructor,
                    "jira/inline-issue-create/entities/inline-bootstrap": this.IicBootstrap.constructor
                });
                this.inlineIssueCreate = new this.InlineIssueCreateConstructor();
            }
        });

        test("When Boostrap is synchronized, it sets the JQL in the widget", function() {
            this.IicBootstrap.jqls = ["project = KEY"];

            this.IicBootstrap.trigger("sync");

            sinon.assert.calledOnce(this.IicWidget.setCurrentJQLs);
            sinon.assert.calledWith(this.IicWidget.setCurrentJQLs, ["project = KEY"]);
        });

        test("When the issue is created, it triggers the event 'issueCreated' with the issue and the fields", function() {
            var onIssueCreated = this.spy();
            this.inlineIssueCreate.on("issueCreated", onIssueCreated);
            var issue = {};
            var fields = {};

            this.IicWidget.trigger("issueCreated", issue, fields);

            sinon.assert.calledOnce(onIssueCreated);
            sinon.assert.calledWith(onIssueCreated, {issue: issue, fields: fields});
        });

        test("When the issue is created, it triggers the event 'issueCreated' with the issue and the fields", function() {
            var onIssueCreated = this.spy();
            this.inlineIssueCreate.on("issueCreated", onIssueCreated);
            var issue = {};
            var fields = {};

            this.IicWidget.trigger("issueCreated", issue, fields);

            sinon.assert.calledOnce(onIssueCreated);
            sinon.assert.calledWith(onIssueCreated, {issue: issue, fields: fields});
        });

        test("When the widget is activated, it triggers the event 'activated'", function() {
            var onActivated = this.spy();
            this.inlineIssueCreate.on("activated", onActivated);

            this.IicWidget.trigger("activated");

            sinon.assert.calledOnce(onActivated);
        });

        test("When the widget is deactivated, it triggers the event 'deactivated'", function() {
            var onDeactivated = this.spy();
            this.inlineIssueCreate.on("deactivated", onDeactivated);

            this.IicWidget.trigger("deactivated");

            sinon.assert.calledOnce(onDeactivated);
        });

        test("When the trigger is selected, it triggers the event 'inlineIssueCreateOpened", function() {
            var onOpened = this.spy();
            this.inlineIssueCreate.on("inlineIssueCreateOpened", onOpened);

            this.IicTrigger.trigger("selected");

            sinon.assert.calledOnce(onOpened);
        });

        test("When the trigger is selected, it activate the widget", function() {
            this.IicTrigger.trigger("selected");

            sinon.assert.calledOnce(this.IicWidget.activate);
        });

        test("When the trigger is selected and the widget activated, we pass the focus to the widget", function() {
            this.IicWidget.activate.returns(true);
            this.IicTrigger.trigger("selected");

            sinon.assert.calledOnce(this.IicWidget.focus);
        });

        test("When the component is shown in an element, we render the trigger inside that element", function() {
            this.IicTrigger.$el = AJS.$('<div></div>');
            var el = AJS.$('<div></div>');
            this.IicTrigger.render.reset();

            this.inlineIssueCreate.show(el);

            sinon.assert.calledOnce(this.IicTrigger.render);
            ok(jQuery.contains(el, this.IicTrigger.$el));
        });

        test("When the component is shown in an element, we render the widget inside that element", function() {
            this.IicWidget.$el = AJS.$('<div></div>');
            var el = AJS.$('<div></div>');
            this.IicWidget.render.reset();
            this.IicWidget.attach.reset();

            this.inlineIssueCreate.show(el);

            sinon.assert.calledOnce(this.IicWidget.render);
            sinon.assert.calledOnce(this.IicWidget.attach);
            sinon.assert.calledWith(this.IicWidget.attach, el);
        });

        test("When we activate the component, if there are no projects in the Bootstrap model, it opens the createIssue dialog", function() {
            this.IicBootstrap.projects = [];

            this.inlineIssueCreate.activate();

            sinon.assert.calledOnce(this.IicWidget.openCreateIssueDialog);
        });

        test("When we activate the component, if there are projects in the Bootstrap model, we activate the widget", function() {
            this.IicBootstrap.projects = ["non-empty-list"];

            this.inlineIssueCreate.activate();

            sinon.assert.calledOnce(this.IicWidget.activate);
        });

        test("When we activate the component, if there are projects in the Bootstrap model, we activate the widget", function() {
            this.IicBootstrap.projects = ["non-empty-list"];

            this.inlineIssueCreate.activate();

            sinon.assert.calledOnce(this.IicWidget.activate);
        });

        test("When we want to activate the component with a JQL, it sets the JQL in the bootstrap object", function() {
            this.IicBootstrap.fetch.returns(new jQuery.Deferred());

            this.inlineIssueCreate.activateWithJQL("some jql");

            deepEqual(this.IicBootstrap.jqls, ["some jql"]);
        });

        test("When we want to activate the component with a JQL, we activate the component if the bootstrap has projects", function() {
            var deferred = new jQuery.Deferred().resolve().promise();
            this.IicBootstrap.fetch.returns(deferred);
            this.IicBootstrap.projects = ["non-empty-list"];

            this.inlineIssueCreate.activateWithJQL("some jql");

            sinon.assert.calledOnce(this.IicWidget.activate);
        });

        test("When we want to activate the component with a JQL, we activate the component if the bootstrap has no projects", function() {
            var deferred = new jQuery.Deferred().resolve().promise();
            this.IicBootstrap.fetch.returns(deferred);
            this.IicBootstrap.projects = [];

            this.inlineIssueCreate.activateWithJQL("some jql");

            sinon.assert.notCalled(this.IicWidget.activate);
        });
    });
});
