define("jira/components/detailslayout/views/tools", ['require'], function (require) {
    "use strict";

    var Marionette = require('jira/components/libs/marionette-2.1.0');
    var Templates = require('jira/components/detailslayout/templates');
    var KeyboardShortcut = require('jira/ajs/keyboardshortcut/keyboard-shortcut');

    return Marionette.LayoutView.extend({
        initialize: function(options) {
            this.showExpand = options.showExpand;
        },

        template: Templates.tools,

        regions: {
            pager: ".pager-container"
        },

        ui: {
            expand: ".expand"
        },

        triggers: {
            "click @ui.expand": "expand"
        },

        serializeData: function() {
            return {
                showExpand: this.showExpand || false,
                expandShortcutKey: KeyboardShortcut.getKeyboardShortcutKeys('fullscreen.issue')
            };
        },

        onRender: function() {
            if (this.showExpand) {
                this.ui.expand.tooltip({
                    gravity: 'e'
                });
            }
        },

        onDestroy: function() {
            //Destroy could have been called before rendering the View, in that case we won't have this.ui.expand.tooltip
            if (this.showExpand && this.ui.expand.tooltip) {
                this.ui.expand.tooltip('hide');
            }
        }
    });
});
