define("jira/components/detailslayout/views/layout", ['require'], function (require) {
    "use strict";

    var Marionette = require('jira/components/libs/marionette-2.1.0');
    var _ = require('jira/components/libs/underscore');
    var Templates = require('jira/components/detailslayout/templates');

    return Marionette.LayoutView.extend({
        template: Templates.layout,

        regions: {
            issuesList: ".list-results-panel",
            issueComponent: ".issue-container",
            tools: ".tools-container"
        },

        ui: {
            detailPanel: '.detail-panel'
        },

        onRender: function() {
            this.issuesList._ensureElement();
        },

        maximizeDetailPanelHeight: function() {
            var issueContainerTop = this.ui.detailPanel.offset().top;
            this.ui.detailPanel.css("height", window.innerHeight - issueContainerTop);
        },

        showDraggable: function() {
            var oldSize = 0;

            this.issuesList.$el.sidebar({
                id: "layoutview-draggable",
                minWidth: function () {
                    return 250;
                },
                maxWidth: _.bind(function () {
                    return this.$el.width() - 500;
                }, this),
                resize: _.bind(function(newSize) {
                    // This should be handled by the sidebar plugin :(
                    if (newSize !== oldSize) {
                        oldSize = newSize;
                        this.trigger("resize");
                    }
                }, this)
            });
        },

        updateDraggable: function() {
            this.issuesList.$el.sidebar("updatePosition");
        }
    });
});
