define("jira/components/detailslayout/views/container", ['require'], function (require) {
    "use strict";

    var Marionette = require('jira/components/libs/marionette-2.1.0');
    var Templates = require('jira/components/detailslayout/templates');

    return Marionette.ItemView.extend({
        template: Templates.container,

        onRender: function () {
            this.unwrapTemplate();
        },

        showView: function(view) {
            this.$el.append(view.$el);
        },

        showLoading: function(loadingView) {
            this.$el.prepend(loadingView.$el);
        },

        hideLoading: function(loadingView) {
            loadingView.$el.detach();
        }
    });
});
