AJS.test.require("com.atlassian.jira.jira-issue-nav-components:detailslayout-test", function () {
    "use strict";

    require([
        "jira/components/pager",
        "jira/components/detailslayout/views/tools",
        "jira/components/test-utils/mockutils",
        "jquery",
        "jira/components/search/results"
    ], function (
        Pager,
        ToolsView,
        MockUtils,
        jQuery,
        SearchResults
    ) {
        module("jira/components/detailslayout/controllers/tools", {
            setup: function() {
                this.sandbox = sinon.sandbox.create();

                var ToolsViewSpied = MockUtils.spyAll(this.sandbox, ToolsView);
                var PagerSpied = MockUtils.spyAll(this.sandbox, Pager);
                this.ToolsConstructor = MockUtils.requireWithMocks("jira/components/detailslayout/controllers/tools", {
                    "jira/components/pager": PagerSpied,
                    "jira/components/detailslayout/views/tools": ToolsViewSpied
                });

                this.tools = new this.ToolsConstructor({
                    showExpand: true
                });
                this.pager = PagerSpied.getInstance();
                this.toolsView = ToolsViewSpied.getInstance();
                this.fakeSearchResults = new SearchResults();

                this.fakeSearchResults = new SearchResults([{id: 10001, key: 'KEY-1'}, {id: 10002, key: 'KEY-2'}], {
                    issues: [{id: 10001, key: 'KEY-1'}, {id: 10002, key: 'KEY-2'}],
                    pageSize: 1,
                    totalRecordsInDB: 2,
                    totalRecordsInSearch: 1
                });
                this.fakeSearchResults.select('KEY-1');
            },

            teardown: function() {
                this.sandbox.restore();
            },

            constructTools: function(el, options) {
                var tools = new this.ToolsConstructor(options);
                tools.show(el);
                tools.load(this.fakeSearchResults);
                return tools;
            }
        });

        test("When we load the Tools with new SearchResults, it updates the SearchResults in the Pager", function() {
            this.tools.load(this.fakeSearchResults);

            sinon.assert.calledOnce(this.pager.update);
            sinon.assert.calledWith(this.pager.update, this.fakeSearchResults);
        });

        test("When the Tools are destroyed, the Pager is destroyed too ", function() {
            this.tools.destroy();

            sinon.assert.calledOnce(this.pager.destroy);
        });

        test("When the Tools is rendered in an element, it renders the main view in that element", function() {
            var el = jQuery("<div/>");

            this.tools.show(el);

            ok(el.find('.issue-tools').length === 1);
        });

        test("When the Tools view is rendered, we render the Pager inside", function() {
            var el = jQuery("<div/>");
            this.tools.show(el);
            this.tools.load(this.fakeSearchResults);

            ok(el.find('.pager-container').children().length > 0);
        });

        test("When the Tools are constructed, it doesn't display the 'expand' button by default", function() {
            var el = jQuery("<div/>");
            this.constructTools(el);

            ok(el.find(".expand").length === 0);
        });

        test("When the Tools are constructed, it can show the 'expand' button", function() {
            var el = jQuery("<div/>");
            this.constructTools(el, {showExpand: true});

            ok(el.find(".expand").length === 1);
        });

        test("When the 'Expand' tool is clicked, we trigger the event 'expand'", function() {
            var el = jQuery("<div/>");
            var tools = this.constructTools(el, {showExpand: true});
            var onExpand = this.spy();
            tools.on('expand', onExpand);

            el.find('.expand').click();

            sinon.assert.called(onExpand);
        });

        test("When the 'next' arrow in the Pager is clicked, we trigger the event 'pager:next'", function() {
            var el = jQuery("<div/>");
            var tools = this.constructTools(el);
            var onPagerNext = this.spy();
            tools.on('pager:next', onPagerNext);

            el.find('.next a').click();

            sinon.assert.called(onPagerNext);
        });

        test("When the 'previous' arrow in the Pager is clicked, we trigger the event 'pager:previous'", function() {
            this.fakeSearchResults.select('KEY-2');
            var el = jQuery("<div/>");
            var tools = this.constructTools(el);
            var onPagerPrevious = this.spy();
            tools.on('pager:previous', onPagerPrevious);

            el.find('.previous a').click();

            sinon.assert.called(onPagerPrevious);
        });
    });
});
