AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:testutils","com.atlassian.jira.jira-issue-nav-components:columnpicker"],function(){require(["jira/components/libs/underscore","jira/components/columnpicker/view","jira/components/columnpicker/model","jira/components/columnpicker/columnconfigmodel","jira/components/columnpicker/sparklerview","aui/inline-dialog","jquery"],function(g,c,a,d,h,e,i){var b=window.AJS.params;var f=window.AJS.test;module("jira/components/columnpicker/view",{setup:function(){this.clock=sinon.useFakeTimers();b.ignoreFrame=true;this.$container=i(["<div></div>"].join(""));this.createModel=function(){return new a({columnConfig:"user"})};this.model=this.createModel();this.model.addColumnProvider("user",d.create("user","User"));this.model.addColumnProvider("filter",d.create("filter","Filter"));this.createView=g.bind(function(j){return new c({el:i("#qunit-fixture"),columnPickerModel:j||this.model})},this);this.view=this.createView(this.model);this.selectors={bothButtons:".check-list-top-panel button[type=button]",userButton:".check-list-top-panel button[type=button][data-value=user]",filtersButton:".check-list-top-panel button[type=button][data-value=filter]"}},teardown:function(){if(this.view.dialog){this.view.dialog.hide()}this.view=null;this.model=null;this.clock.tick(100);this.clock.restore()}});test("_onDOMConfigChooserClick() change the buttons to reflect the new columnConfig state",function(){this.view.render();this.view._onDOMTriggerClick();ok(this.view.dialog.find("#columns-chooser-user").hasClass("active"),"User button is active");ok(!this.view.dialog.find("#columns-chooser-filter").hasClass("active"),"Filter button is not active");var j=new i.Event();j.target=this.view.dialog.find("#columns-chooser-filter");j.target.removeAttr("aria-disabled");this.view._onDOMConfigChooserClick(j);ok(!this.view.dialog.find("#columns-chooser-user").hasClass("active"),"User button is not active after change:columnConfig");ok(this.view.dialog.find("#columns-chooser-filter").hasClass("active"),"Filter button is active after change:columnConfig");equal(this.model.getColumnConfig(),"filter","The new column config has been saved into the model")});test("_onDOMConfigChooserClick() does nothing if the button is disabled",function(){sinon.stub(this.model.columnsData.filter,"isDisabled").returns(true);this.view.render();this.view._onDOMTriggerClick();var j=new i.Event();j.target=this.view.dialog.find("#columns-chooser-filter");this.view._onDOMConfigChooserClick(j);ok(this.view.dialog.find("#columns-chooser-user").hasClass("active"),"User button is still active after the click");ok(!this.view.dialog.find("#columns-chooser-filter").hasClass("active"),"Filter button is still inactive after the click");equal(this.model.getColumnConfig(),"user","ColumnConfig has not changed")});test("_activateNewSubView() should refresh the search if the column config is ready to be used",function(){this.view.render();this.view._onDOMTriggerClick();var j=this.view.activeSubview;sinon.stub(this.model,"shouldCloseOnActivation").returns(true);sinon.stub(this.model,"shouldRefreshSearchOnActivation").returns(true);sinon.stub(this.model,"refreshSearchWithColumns");sinon.stub(this.view.dialog,"hide");this.view._activateNewSubView(j);ok(this.model.refreshSearchWithColumns.calledOnce,"The search has been refreshed");ok(this.view.dialog.hide.calledOnce,"The search has been refreshed");this.view.dialog.hide.restore()});test("_activateNewSubView() should load the default columns and display the new subview if it is not ready",function(){this.view.render();this.view._onDOMTriggerClick();var j=this.view.activeSubview;sinon.stub(this.model,"shouldCloseOnActivation").returns(false);sinon.stub(this.model,"shouldLoadDefaultsOnActivation").returns(true);sinon.stub(this.model,"loadDefaultColumns");sinon.stub(this.view,"adjustHeight");sinon.stub(j,"show");this.view._activateNewSubView(j);ok(this.model.loadDefaultColumns.calledOnce,"The model has loaded the default columns");ok(j.show.calledOnce,"The new subView is displayed");ok(j===this.view.activeSubview,"The new subView is saved as active");ok(this.view.adjustHeight,"The dialog height should be corrected")});test("_onDOMFormSubmit() should save the columns of the active view and close the dialog",function(){this.view.render();this.view._onDOMTriggerClick();sinon.stub(this.view.activeSubview,"saveColumns");sinon.stub(this.view.dialog,"hide");this.view._onDOMFormSubmit(new i.Event());ok(this.view.activeSubview.saveColumns.calledOnce);ok(this.view.dialog.hide.calledOnce);this.view.dialog.hide.restore()});test("_onDOMCloseDialogClick() should close the dialog",function(){this.view.render();this.view.dialog.show();sinon.stub(this.view.dialog,"hide");this.view._onDOMCloseDialogClick();ok(this.view.dialog.hide.calledOnce);this.view.dialog.hide.restore()});test("_onDOMTriggerClick() should request the available columns",function(){sinon.stub(this.model,"fetchAvailableColumnsIfNeeded");this.view.render();this.view._onDOMTriggerClick();ok(this.model.fetchAvailableColumnsIfNeeded.calledOnce)});test("_onDOMTriggerClick() should set the correct subView",function(){this.view.render();equal(this.view.activeSubview,null);this.view._onDOMTriggerClick();ok(this.view.activeSubview instanceof h,"Should create a reference to the active subView");equal(this.view.activeSubview.model.getName(),"user","The active subView should render the 'user' model")});test("_onDOMDialogHide() should hide the current subView",function(){this.view.render();this.view.$trigger.click();sinon.stub(this.model,"revertColumnConfig");sinon.stub(this.view.activeSubview,"hide");this.view._onDOMDialogHide();ok(this.view.activeSubview.hide.calledOnce)});test("_onModelChangeColumnConfig() should change the buttons to reflect the new columnConfig state",function(){this.view.render();this.view.dialog.show();ok(this.view.dialog.find("#columns-chooser-user").hasClass("active"),"User button is active");ok(!this.view.dialog.find("#columns-chooser-filter").hasClass("active"),"Filter button is not active");sinon.stub(this.model,"previous").returns("user");this.view._onModelChangeColumnConfig(this.model,"filter");ok(!this.view.dialog.find("#columns-chooser-user").hasClass("active"),"User button is not active after change:columnConfig");ok(this.view.dialog.find("#columns-chooser-filter").hasClass("active"),"Filter button is active after change:columnConfig")});test("_onModelChangeAvailableColumns() should create the sparkerl control in the subviews",function(){var j=i("<div></div>");this.view._createSubViews(j);var k=[{label:"label 1",value:"value 1"},{label:"label 2",value:"value 2"}];g.each(this.view.subViews,function(l){sinon.stub(l,"createSparklerControl")});this.view._onModelChangeAvailableColumns(this.model,k);g.each(this.view.subViews,function(l){ok(l.createSparklerControl.calledOnce);ok(l.createSparklerControl.calledWith(k))})});test("_onModelChangeColumnConfigDisabled() should disable the button if the model is disabled",function(){sinon.stub(this.model.columnsData.filter,"isDisabled").returns(true);this.view.render();this.view._onDOMTriggerClick();equal(this.view.dialog.find("#columns-chooser-filter").attr("aria-disabled"),"true","Filter button is initially disabled");this.view._onModelChangeColumnConfigDisabled(this.model.columnsData.filter,false);ok(!this.view.dialog.find("#columns-chooser-filter").attr("aria-disabled"),"Filter button is enabled after a change in the model");this.view._onModelChangeColumnConfigDisabled(this.model.columnsData.filter,true);equal(this.view.dialog.find("#columns-chooser-filter").attr("aria-disabled"),"true","Filter button is disabled after a change in the model")});test("render() builds the trigger icon",function(){this.view.render();ok(this.view.$trigger.is(".column-picker-trigger"))});test("render() binds the trigger to the handler",function(){sinon.stub(this.view,"_onDOMTriggerClick");this.view.render();this.view.$trigger.click();ok(this.view._onDOMTriggerClick.calledOnce,"Click on the trigger should call the handler")});test("_generateInlineDialogContent() generates the dialog content",function(){var j=i("<div></div>");var k=this.selectors;this.view._generateInlineDialogContent(j,null,function(){ok(j.find("form.column-picker").length,"It generates a form");ok(j.find(k.bothButtons).length===2,"It generates two buttons inside the form");ok(j.find(k.bothButtons).eq(0).attr("data-value")==="user","The first button is bound to user columns");ok(j.find(k.bothButtons).eq(1).attr("data-value")==="filter","The second button is bound to filter columns")})});test("_generateInlineDialogContent() disables the filter option if there is no active filter",function(){var k=i("<div></div>");var l=this.selectors;var j=sinon.stub(this.model.columnsData.filter,"isDisabled").returns(true);this.view._generateInlineDialogContent(k,null,function(){equal(k.find(l.filtersButton).attr("aria-disabled"),"true","Button for filter is disabled")});j.restore()});test("_generateInlineDialogContent() enables the filter option if there is an active filter",function(){var k=i("<div></div>");var l=this.selectors;var j=sinon.stub(this.model.columnsData.filter,"isDisabled").returns(false);this.view._generateInlineDialogContent(k,null,function(){ok(!k.find(l.filtersButton).attr("aria-disabled"),"Button for filter is not disabled")});j.restore()});test("_generateInlineDialogContent() selects the 'user' sparkler if the column config is 'user'",function(){var j=i("<div></div>");var k=this.selectors;this.model.setColumnConfig("user");this.view._generateInlineDialogContent(j,null,function(){ok(j.find(k.userButton).hasClass("active"));ok(!j.find(k.filtersButton).hasClass("active"))})});test("_generateInlineDialogContent() selects the 'filter' option if useUserColumns is false",function(){var j=i("<div></div>");var k=this.selectors;this.model.setColumnConfig("filter");this.view._generateInlineDialogContent(j,null,function(){ok(!j.find(k.userButton).hasClass("active"));ok(j.find(k.filtersButton).hasClass("active"))})});test("_generateInlineDialogContent() sets the handler for the close link",function(){var k=i("<div></div>");var j=sinon.stub(this.view,"_onDOMCloseDialogClick");this.view._generateInlineDialogContent(k,null,function(){k.find(".close-dialog").click();ok(j.calledOnce)})});test("_generateInlineDialogContent() sets the handler for form submission",function(){var k=i("<div></div>");var j=sinon.stub(this.view,"_onDOMFormSubmit");this.view._generateInlineDialogContent(k,null,function(){k.find("form").submit(function(l){l.preventDefault()});k.find("form").submit();ok(j.calledOnce)})});test("_renderInlineDialog() creates the dialog the first time",function(){var k=this.spy(e);this.moduleMocks=f.mockableModuleContext();this.moduleMocks.mock("aui/inline-dialog",k);var m=this.moduleMocks.require("jira/components/columnpicker/view");var j=new m({el:i("#qunit-fixture"),columnPickerModel:this.model});j._renderInlineDialog();ok(k.calledOnce,"Should create a AJS.InlineDialog");ok(j.dialog instanceof i,"Should store the dialog in view.dialog");var l=j.dialog;j._renderInlineDialog();ok(l===j.dialog,"Should reuse the current dialog if present")});test("_createSubViews() creates a sparkler for each submodel",function(){var j=i("<div></div>");this.view._createSubViews(j);ok(this.view.subViews.filter instanceof h);ok(this.view.subViews.user instanceof h)});test("_createSubViews() adds a listener for change:columnConfig",function(){sinon.stub(this.view,"_onModelChangeColumnConfig");var j=i("<div></div>");this.view._createSubViews(j);this.model.trigger("change:columnConfig");ok(this.view._onModelChangeColumnConfig.calledOnce)});test("_renderInlineDialog() adds a listener for change:availableColumns",function(){sinon.stub(this.view,"_onModelChangeAvailableColumns");var j=i("<div></div>");this.view._createSubViews(j);this.model.trigger("change:availableColumns");ok(this.view._onModelChangeAvailableColumns.calledOnce)})})});