define("jira/components/columnpicker/suggesthandler", ["require"], function(require){
    "use strict";

    var _ = require("jira/components/libs/underscore");
    var GroupDescriptor = require("jira/ajs/list/group-descriptor");
    var jQuery = require("jquery");
    var SelectSuggestHandler = require('jira/ajs/select/suggestions/select-suggest-handler');
    var SuggestHandler = require("jira/ajs/select/suggestions/suggest-helper");
    var Templates = window.JIRA.Templates.Dialogs.ColumnPicker;

    return SelectSuggestHandler.extend({

        /**
         * Creates a actionBar item that contains a link. This link is usually used
         * to restore the defaults items in the sparkler
         *
         * @param {string} [text] Text to render inside the link
         *
         * @return {jQuery} LI element that contains the link
         */
        createActionBar: function(text) {
            //If there are no text, create nothing
            if (!text) {
                return null;
            }

            var $element = jQuery(Templates.restoreDefaultsLink({
                linkText: text
            }));

            $element.click(function(ev) {
                if (jQuery(ev.target).attr("aria-disabled") !== "true") {
                    $element.trigger("actionclick");
                }
                ev.preventDefault();
            });

            return jQuery("<li class='check-list-group-actions'></li>").append($element);
        },

        /**
         * Formats descriptors for display in checkbox multiselect
         *
         * @param descriptors
         * @return {Array} formatted descriptors
         */
        formatSuggestions: function(descriptors, query) {
            var selectedItems = SuggestHandler.removeDuplicates(this.model.getDisplayableSelectedDescriptors());
            var selectedGroup = new GroupDescriptor({
                styleClass: "selected-group",
                items: selectedItems
            });
            descriptors.splice(0, 0, selectedGroup);

            //Add the actionBar to the first group with items, so it is rendered as the first item in the scroll list
            //If there are selected elements, it will be the selectedItems group
            //If not, it will be the uneslectedItems group.
            var firstGroupWithItems = _.find(descriptors, function(group) {
                return group.items().length;
            });
            if (firstGroupWithItems) {
                firstGroupWithItems.actionBarHtml(this.createActionBar(this.options.actionBar));
            }

            if (query.length > 0) {
                descriptors = SuggestHandler.removeDuplicates(descriptors);
                // Extract all items from the descriptors and sort them by label.
                var items = SuggestHandler.extractItems(descriptors).sort(function(a, b) {
                    a = a.label().toLowerCase();
                    b = b.label().toLowerCase();
                    return a.localeCompare(b);
                });
                descriptors = [new GroupDescriptor({items: items})];
            }
            return descriptors;
        }
    });

});
AJS.namespace("JIRA.Issues.ColumnPickerSuggestHandler", null, require("jira/components/columnpicker/suggesthandler"));
