/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.util;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.components.util.FilterLookerUpper;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;

@ExportAsService
@Named
public class DefaultFilterLookerUpper
implements FilterLookerUpper {
    private static final String FILTER_ID = "filterId";
    private static final String FILTER_PREFIX = "filter-";
    private static final String JQL_PREFIX = "jql-";
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SearchService searchService;
    private final SearchRequestService searchRequestService;

    @Inject
    public DefaultFilterLookerUpper(JiraAuthenticationContext jiraAuthenticationContext, SearchService searchService, SearchRequestService searchRequestService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.searchService = searchService;
        this.searchRequestService = searchRequestService;
    }

    @Override
    public SearchRequest getSearchRequestFromFilterId(String filterId, ErrorCollection errors) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        SearchRequest searchRequest = null;
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
        if (StringUtils.isBlank((String)filterId)) {
            errors.addError(FILTER_ID, this.jiraAuthenticationContext.getI18nHelper().getText("gadget.common.no.filter.id"));
        } else {
            if (filterId.startsWith(JQL_PREFIX)) {
                SearchService.ParseResult parseResult = this.searchService.parseQuery(user, filterId.substring(JQL_PREFIX.length()));
                if (parseResult.isValid()) {
                    searchRequest = new SearchRequest(parseResult.getQuery());
                } else {
                    for (String errorMessage : parseResult.getErrors().getErrorMessages()) {
                        errors.addError(FILTER_ID, this.jiraAuthenticationContext.getI18nHelper().getText("gadget.common.invalid.filter.validationfailed", (Object)CollectionBuilder.newBuilder((Object[])new String[]{filterId, errorMessage}).asList()));
                    }
                }
            } else {
                searchRequest = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, this.stripFilterPrefix(filterId, FILTER_PREFIX));
            }
            if (searchRequest == null) {
                errors.addErrorMessage(this.jiraAuthenticationContext.getI18nHelper().getText("admin.errors.filters.nonexistent"));
            }
        }
        return searchRequest;
    }

    private Long stripFilterPrefix(String filterId, String prefix) {
        if (filterId.startsWith(prefix)) {
            String numPart = filterId.substring(prefix.length());
            return Long.valueOf(numPart);
        }
        return Long.valueOf(filterId);
    }
}

