/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.query;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.components.query.SearchRendererValueResults;
import com.atlassian.jira.components.query.SearcherService;
import com.atlassian.jira.components.query.util.ActionUtils;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugins.rest.common.json.DefaultJaxbJsonMarshaller;
import java.io.IOException;
import webwork.action.ActionContext;

public class QueryRendererValueAction
extends JiraWebActionSupport {
    private final SearcherService searcherService;
    private SearchRendererValueResults results;
    private ErrorCollection errors;

    public QueryRendererValueAction(SearcherService searcherService) {
        this.searcherService = searcherService;
    }

    public String doDefault() throws IOException {
        ActionContext.getResponse().setContentType("application/json");
        ServiceOutcome<SearchRendererValueResults> outcome = this.searcherService.getViewHtml(this, ActionContext.getParameters());
        if (outcome.isValid()) {
            this.results = (SearchRendererValueResults)outcome.getReturnedValue();
            return this.JSON();
        }
        this.errors = ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)outcome.getErrorCollection());
        ActionUtils.setErrorReturnCode(this.getLoggedInUser());
        return this.ERROR_JSON();
    }

    private String ERROR_JSON() throws IOException {
        ActionContext.getResponse().getWriter().append(this.getErrorJson());
        return "none";
    }

    private String JSON() throws IOException {
        ActionContext.getResponse().getWriter().append(this.getJson());
        return "none";
    }

    public String getJson() {
        DefaultJaxbJsonMarshaller marshaller = new DefaultJaxbJsonMarshaller();
        return marshaller.marshal((Object)this.results);
    }

    public String getErrorJson() {
        DefaultJaxbJsonMarshaller marshaller = new DefaultJaxbJsonMarshaller();
        return marshaller.marshal((Object)this.errors);
    }
}

