/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.query;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.components.query.SearchResults;
import com.atlassian.jira.components.query.SearcherService;
import com.atlassian.jira.components.query.util.ActionUtils;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugins.rest.common.json.DefaultJaxbJsonMarshaller;
import java.io.IOException;
import webwork.action.ActionContext;

public class QueryAction
extends JiraWebActionSupport {
    private final SearcherService searcherService;
    private String jql;
    private String filter;

    public QueryAction(SearcherService searcherService) {
        this.searcherService = searcherService;
    }

    public String doDefault() throws IOException {
        ActionContext.getResponse().setContentType("application/json");
        ServiceOutcome<SearchResults> outcome = this.searcherService.search(this, ActionContext.getParameters(), this.getFilter());
        if (outcome.isValid()) {
            return QueryAction.JSON(outcome.getReturnedValue());
        }
        return QueryAction.JSON(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)outcome.getErrorCollection()));
    }

    public String doJql() throws IOException {
        ActionContext.getResponse().setContentType("application/json");
        ServiceOutcome<SearchResults> outcome = this.searcherService.searchWithJql(this, this.jql, this.getFilter());
        if (outcome.isValid()) {
            return QueryAction.JSON(outcome.getReturnedValue());
        }
        ActionUtils.setErrorReturnCode(this.getLoggedInUser());
        return QueryAction.JSON(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)outcome.getErrorCollection()));
    }

    private static String JSON(Object bean) throws IOException {
        DefaultJaxbJsonMarshaller marshaller = new DefaultJaxbJsonMarshaller();
        String json = marshaller.marshal(bean);
        ActionContext.getResponse().getWriter().append(json);
        return null;
    }

    public String getJql() {
        return this.jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    public long getFilter() {
        try {
            return Long.valueOf(this.filter);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }
}

