/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.query;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.components.query.FilteredSearcherGroup;
import com.atlassian.jira.components.query.PrimarySearchers;
import com.atlassian.jira.components.query.RecentSearchersService;
import com.atlassian.jira.components.query.SearchContextHelper;
import com.atlassian.jira.components.query.SearchRendererValue;
import com.atlassian.jira.components.query.SearchRendererValueResults;
import com.atlassian.jira.components.query.SearchResults;
import com.atlassian.jira.components.query.Searcher;
import com.atlassian.jira.components.query.SearcherService;
import com.atlassian.jira.components.query.Searchers;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.IssueSearcherPanelMap;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.issue.transport.impl.ActionParamsImpl;
import com.atlassian.jira.issue.transport.impl.FieldValuesHolderImpl;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.Clause;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import webwork.action.Action;

@ExportAsService
@Named
public class DefaultSearcherService
implements SearcherService {
    private static final String JQL_PREFIX = "__jql_";
    private static final String JQL_CONTEXT = "jqlContext";
    private final SearchContextHelper searchContextHelper;
    private final IssueSearcherManager issueSearcherManager;
    private final SearchHandlerManager searchHandlerManager;
    private final JqlStringSupport jqlStringSupport;
    private final JiraAuthenticationContext authenticationContext;
    private final SearchService searchService;
    private final VelocityTemplatingEngine templatingEngine;
    private RecentSearchersService recentSearchersService;
    private static final String JQL_INVALID_ERROR_MESSAGE = "jqlInvalid";
    private static final String JQL_TOO_COMPLEX_ERROR_MESSAGE = "jqlTooComplex";
    private final EmptySearchResultHtmlProvider emptySearchResultHtmlProvider;

    @Inject
    public DefaultSearcherService(SearchContextHelper searchContextHelper, IssueSearcherManager issueSearcherManager, JqlStringSupport jqlStringSupport, JiraAuthenticationContext authenticationContext, SearchHandlerManager searchHandlerManager, SearchService searchService, VelocityTemplatingEngine templatingEngine, RecentSearchersService recentSearchersService) {
        this.searchContextHelper = searchContextHelper;
        this.issueSearcherManager = issueSearcherManager;
        this.jqlStringSupport = jqlStringSupport;
        this.authenticationContext = authenticationContext;
        this.searchHandlerManager = searchHandlerManager;
        this.searchService = searchService;
        this.templatingEngine = templatingEngine;
        this.recentSearchersService = recentSearchersService;
        this.emptySearchResultHtmlProvider = new EmptySearchResultHtmlProvider();
    }

    @Override
    public ServiceOutcome<SearchRendererValueResults> getViewHtml(JiraWebActionSupport action, Map<String, String[]> params) {
        Collection searchers;
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        ServiceOutcome<Map<String, SearchRendererHolder>> clausesOutcome = this.generateQuery(params, user, searchers = this.issueSearcherManager.getAllSearchers());
        if (!clausesOutcome.isValid()) {
            return new ServiceOutcomeImpl(clausesOutcome.getErrorCollection());
        }
        Map clauses = (Map)clausesOutcome.getReturnedValue();
        String[] jqlContext = params.get(JQL_CONTEXT);
        Query query = this.buildQuery(clauses);
        SearchContext searchContext = jqlContext != null ? this.searchContextHelper.getSearchContextFromJqlString(jqlContext[0]) : this.searchService.getSearchContext(user, query);
        return this.getValueResults(false, action, user, searchers, clauses, query, searchContext);
    }

    @Override
    public ServiceOutcome<SearchResults> search(JiraWebActionSupport action, Map<String, String[]> params, Long filterId) {
        Collection searchers;
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        ServiceOutcome<Map<String, SearchRendererHolder>> clausesOutcome = this.generateQuery(params, user, searchers = this.issueSearcherManager.getAllSearchers());
        if (!clausesOutcome.isValid()) {
            return new ServiceOutcomeImpl(clausesOutcome.getErrorCollection());
        }
        Map clauses = (Map)clausesOutcome.getReturnedValue();
        Query query = this.buildQuery(clauses);
        SearchContext searchContext = this.searchService.getSearchContext(user, query);
        return this.getSearchResults(true, action, user, searchers, clauses, query, searchContext);
    }

    @Override
    public ServiceOutcome<SearchResults> searchWithJql(JiraWebActionSupport action, String jqlContext, Long filterId) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jqlContext);
        if (!parseResult.isValid()) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(JQL_INVALID_ERROR_MESSAGE);
            for (String error : parseResult.getErrors().getErrorMessages()) {
                errors.addError("jql", error);
            }
            if (!errors.hasAnyErrors()) {
                errors.addError("jql", this.authenticationContext.getI18nHelper().getText("jql.parse.unknown.no.pos"));
            }
            return new ServiceOutcomeImpl((ErrorCollection)errors);
        }
        Query query = parseResult.getQuery();
        if (!this.searchService.doesQueryFitFilterForm(user, query)) {
            return ServiceOutcomeImpl.error((String)JQL_TOO_COMPLEX_ERROR_MESSAGE);
        }
        Collection searchers = this.issueSearcherManager.getAllSearchers();
        SearchContext searchContext = this.searchService.getSearchContext(user, parseResult.getQuery());
        Map<String, SearchRendererHolder> clauses = this.generateQuery(searchContext, user, query, searchers);
        return this.getSearchResults(true, action, user, searchers, clauses, query, searchContext);
    }

    private ServiceOutcome<SearchResults> getSearchResults(Boolean includePrimes, JiraWebActionSupport action, ApplicationUser user, Collection<IssueSearcher<?>> searchers, Map<String, SearchRendererHolder> clauses, Query query, SearchContext searchContext) {
        ServiceOutcome<SearchRendererValueResults> outcome = this.getValueResults(includePrimes, action, user, searchers, clauses, query, searchContext);
        if (!outcome.isValid()) {
            return new ServiceOutcomeImpl(outcome.getErrorCollection());
        }
        Searchers renderableSearchers = this.getSearchers(searchContext, user);
        return ServiceOutcomeImpl.ok((Object)new SearchResults(renderableSearchers, (SearchRendererValueResults)outcome.getReturnedValue()));
    }

    @Override
    public ServiceOutcome<String> getEditHtml(String searcherId, String jqlContext, JiraWebActionSupport action) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        SearchContextHelper.SearchContextWithFieldValues searchContextWithFieldValues = this.searchContextHelper.getSearchContextWithFieldValuesFromJqlString(jqlContext);
        return this.getEditHtml(searcherId, (Action)action, user, searchContextWithFieldValues, this.createDisplayParams());
    }

    @Override
    public Searchers getSearchers(String jqlContext) {
        SearchContext searchContext = this.searchContextHelper.getSearchContextFromJqlString(jqlContext);
        return this.getSearchers(searchContext, this.authenticationContext.getLoggedInUser());
    }

    private ServiceOutcome<SearchRendererValueResults> getValueResults(Boolean includePrimes, JiraWebActionSupport action, ApplicationUser user, Collection<IssueSearcher<?>> searchers, Map<String, SearchRendererHolder> clauses, Query query, SearchContext searchContext) {
        Map<String, String> displayParams = this.createDisplayParams();
        SearchRendererValueResults results = new SearchRendererValueResults();
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        for (IssueSearcher<?> issueSearcher : searchers) {
            String id = issueSearcher.getSearchInformation().getId();
            SearchRendererHolder clause = clauses.get(id);
            SearchRenderer searchRenderer = issueSearcher.getSearchRenderer();
            String name = i18nHelper.getText(issueSearcher.getSearchInformation().getNameKey());
            boolean validSearcher = searchRenderer.isShown(user, searchContext);
            if (includePrimes.booleanValue() && this.isPrime(issueSearcher) && validSearcher || searchRenderer.isRelevantForQuery(user, query)) {
                SearchContextHelper.SearchContextWithFieldValues searchContextWithFieldValues;
                FieldValuesHolderImpl params;
                String viewHtml = null;
                SearchInputTransformer searchInputTransformer = issueSearcher.getSearchInputTransformer();
                if (null == clause) {
                    params = new FieldValuesHolderImpl();
                } else if (clause.valid) {
                    params = clause.params;
                } else {
                    params = new FieldValuesHolderImpl();
                    searchInputTransformer.populateFromQuery(user, (FieldValuesHolder)params, (Query)new QueryImpl(clause.clause), searchContext);
                }
                searchInputTransformer.validateParams(user, searchContext, (FieldValuesHolder)params, i18nHelper, (ErrorCollection)action);
                if (searchRenderer.isRelevantForQuery(user, query)) {
                    searchContextWithFieldValues = new SearchContextHelper.SearchContextWithFieldValues(searchContext, (FieldValuesHolder)params);
                    viewHtml = searchRenderer.getViewHtml(user, searchContext, (FieldValuesHolder)params, displayParams, (Action)action);
                } else {
                    searchContextWithFieldValues = this.searchContextHelper.getSearchContextWithFieldValuesFromQuery(searchContext, query);
                }
                ServiceOutcome<String> outcome = this.getEditHtml(id, (Action)action, user, searchContextWithFieldValues, displayParams);
                if (!outcome.isValid()) {
                    return new ServiceOutcomeImpl(outcome.getErrorCollection());
                }
                String editHtml = (String)outcome.getReturnedValue();
                String jql = clause != null ? this.jqlStringSupport.generateJqlString(clause.clause) : null;
                results.put(id, new SearchRendererValue(name, jql, viewHtml, editHtml, validSearcher, validSearcher));
                continue;
            }
            if (clause == null || clause.valid) continue;
            results.put(id, new SearchRendererValue(name, this.jqlStringSupport.generateJqlString(clause.clause), null, null, false, validSearcher));
        }
        return ServiceOutcomeImpl.ok((Object)results);
    }

    private Map<String, SearchRendererHolder> generateQuery(SearchContext searchContext, ApplicationUser user, Query query, Collection<IssueSearcher<?>> searchers) {
        HashMap clauses = Maps.newHashMap();
        for (IssueSearcher<?> issueSearcher : searchers) {
            SearchInputTransformer searchInputTransformer = issueSearcher.getSearchInputTransformer();
            FieldValuesHolderImpl fieldValuesHolder = new FieldValuesHolderImpl();
            searchInputTransformer.populateFromQuery(user, (FieldValuesHolder)fieldValuesHolder, query, searchContext);
            Clause clause = searchInputTransformer.getSearchClause(user, (FieldValuesHolder)fieldValuesHolder);
            if (null == clause) continue;
            String id = issueSearcher.getSearchInformation().getId();
            clauses.put(id, SearchRendererHolder.valid(clause, (FieldValuesHolder)fieldValuesHolder));
        }
        return clauses;
    }

    private ServiceOutcome<Map<String, SearchRendererHolder>> generateQuery(Map<String, String[]> params, ApplicationUser user, Collection<IssueSearcher<?>> searchers) {
        HashMap clauses = Maps.newHashMap();
        ActionParams actionParams = this.getActionParameters(params);
        Map<String, String[]> jqlParams = this.getJqlParameters(params);
        for (IssueSearcher<?> issueSearcher : searchers) {
            Clause clause;
            String id = issueSearcher.getSearchInformation().getId();
            SearchInputTransformer searchInputTransformer = issueSearcher.getSearchInputTransformer();
            if (jqlParams.containsKey(id)) {
                SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jqlParams.get(id)[0]);
                if (parseResult.isValid()) {
                    clause = parseResult.getQuery().getWhereClause();
                    clauses.put(id, SearchRendererHolder.invalid(clause));
                    continue;
                }
                SimpleErrorCollection errors = new SimpleErrorCollection();
                errors.addErrorMessages((Collection)parseResult.getErrors().getErrorMessages());
                return ServiceOutcomeImpl.from((ErrorCollection)errors, null);
            }
            FieldValuesHolderImpl fieldValuesHolder = new FieldValuesHolderImpl();
            searchInputTransformer.populateFromParams(user, (FieldValuesHolder)fieldValuesHolder, actionParams);
            clause = searchInputTransformer.getSearchClause(user, (FieldValuesHolder)fieldValuesHolder);
            if (null == clause) continue;
            clauses.put(id, SearchRendererHolder.valid(clause, (FieldValuesHolder)fieldValuesHolder));
        }
        return ServiceOutcomeImpl.ok((Object)clauses);
    }

    private Query buildQuery(Map<String, SearchRendererHolder> clauses) {
        Collection actualClauses = Collections2.transform(clauses.values(), (Function)new Function<SearchRendererHolder, Clause>(){

            public Clause apply(SearchRendererHolder input) {
                return input.clause;
            }
        });
        AndClause jqlClause = clauses.size() > 0 ? new AndClause(actualClauses) : null;
        return new QueryImpl((Clause)jqlClause);
    }

    private boolean isPrime(IssueSearcher searcher) {
        PrimarySearchers[] primes;
        for (PrimarySearchers prime : primes = PrimarySearchers.values()) {
            if (!prime.getId().equals(searcher.getSearchInformation().getId())) continue;
            return true;
        }
        return false;
    }

    private Searchers getSearchers(SearchContext searchContext, ApplicationUser user) {
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        HashMap<String, FilteredSearcherGroup> searcherGroups = new HashMap<String, FilteredSearcherGroup>();
        Map<String, Long> recentSearchers = this.recentSearchersService.getRecentSearchers(user);
        for (IssueSearcher searcher : this.searchHandlerManager.getAllSearchers()) {
            IssueSearcherPanelMap.Panel panel = IssueSearcherPanelMap.getPanel(searcher.getClass());
            FilteredSearcherGroup group = (FilteredSearcherGroup)searcherGroups.get(panel.name());
            if (group == null) {
                group = new FilteredSearcherGroup(panel.name());
                if (panel.getTitleKey() != null) {
                    group.setTitle(i18nHelper.getText(panel.getTitleKey()));
                }
                searcherGroups.put(panel.name(), group);
            }
            SearcherInformation searcherInfo = searcher.getSearchInformation();
            SearchableField field = searcherInfo.getField();
            String fieldKey = "text";
            if (field != null) {
                fieldKey = field instanceof CustomField ? ((CustomField)field).getCustomFieldType().getKey() : field.getNameKey();
            }
            String searcherId = searcherInfo.getId();
            group.addSearcher(new Searcher(searcherId, i18nHelper.getText(searcherInfo.getNameKey()), fieldKey, searcher.getSearchRenderer().isShown(user, searchContext), recentSearchers.get(searcherId)));
        }
        Searchers searchers = new Searchers();
        searchers.addGroups(searcherGroups.values());
        return searchers;
    }

    private ServiceOutcome<String> getEditHtml(String searcherId, Action action, ApplicationUser user, SearchContextHelper.SearchContextWithFieldValues searchContextWithFieldValues, Map<String, String> displayParams) {
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        if (null == searcherId) {
            return ServiceOutcomeImpl.error((String)i18nHelper.getText("issues.components.query.searcher.no.search.renderer"));
        }
        IssueSearcher issueSearcher = this.issueSearcherManager.getSearcher(searcherId);
        if (null == issueSearcher) {
            return ServiceOutcomeImpl.error((String)i18nHelper.getText("issues.components.query.searcher.no.search.renderer"));
        }
        this.recentSearchersService.addRecentSearcher(user, issueSearcher);
        String editHtml = issueSearcher.getSearchRenderer().getEditHtml(user, searchContextWithFieldValues.searchContext, searchContextWithFieldValues.fieldValuesHolder, displayParams, action);
        if (StringUtils.isEmpty((CharSequence)editHtml)) {
            editHtml = this.emptySearchResultHtmlProvider.getHtml(searcherId);
        }
        return ServiceOutcomeImpl.ok((Object)editHtml);
    }

    private Map<String, String> createDisplayParams() {
        HashMap<String, String> displayParams = new HashMap<String, String>();
        displayParams.put("theme", "aui");
        displayParams.put("checkboxmultiselect", "on");
        return displayParams;
    }

    private ActionParams getActionParameters(Map<String, String[]> params) {
        return new ActionParamsImpl(Maps.filterKeys(params, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !input.startsWith(DefaultSearcherService.JQL_PREFIX);
            }
        }));
    }

    private Map<String, String[]> getJqlParameters(Map<String, String[]> params) {
        HashMap jqlParams = Maps.newHashMap();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            if (!entry.getKey().startsWith(JQL_PREFIX)) continue;
            jqlParams.put(entry.getKey().substring(JQL_PREFIX.length()), entry.getValue());
        }
        return jqlParams;
    }

    private static interface MessageProvider {
        public String getMessage();
    }

    private class EmptySearchResultHtmlProvider {
        private final Map<String, MessageProvider> providers = Maps.newHashMap();

        EmptySearchResultHtmlProvider() {
            this.providers.put("project", new MessageProvider(){

                @Override
                public String getMessage() {
                    return DefaultSearcherService.this.authenticationContext.getI18nHelper().getText("issues.components.query.searcher.no.projects.found");
                }
            });
        }

        String getHtml(String searcherId) {
            if (!this.providers.containsKey(searcherId)) {
                return "";
            }
            String message = this.providers.get(searcherId).getMessage();
            return DefaultSearcherService.this.templatingEngine.render(TemplateSources.file((String)"query/templates/ka-no-results-message.vm")).applying((Map)ImmutableMap.of((Object)"messageHtml", (Object)message)).asHtml();
        }
    }

    private static class SearchRendererHolder {
        public final boolean valid;
        public final Clause clause;
        public final FieldValuesHolder params;

        public static SearchRendererHolder invalid(Clause clause) {
            return new SearchRendererHolder(false, clause, null);
        }

        public static SearchRendererHolder valid(Clause clause, FieldValuesHolder params) {
            return new SearchRendererHolder(true, clause, params);
        }

        private SearchRendererHolder(boolean valid, Clause clause, FieldValuesHolder params) {
            this.valid = valid;
            this.clause = clause;
            this.params = params;
        }
    }
}

