/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.orderby.rest;

import com.atlassian.jira.components.orderby.OrderByUtil;
import com.atlassian.jira.components.orderby.SortByBean;
import com.atlassian.jira.components.orderby.rest.OrderByOption;
import com.atlassian.jira.components.orderby.rest.OrderByOptions;
import com.atlassian.jira.components.orderby.rest.OrderByRequest;
import com.atlassian.jira.components.util.FilterLookerUpper;
import com.atlassian.jira.components.util.NameComparator;
import com.atlassian.jira.components.util.SortJqlGenerator;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.query.Query;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;

@Path(value="orderByOptions")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class OrderByOptionsResource {
    private static final int MAX_RESULTS_HARD_LIMIT = 50;
    private final FieldManager fieldManager;
    private final SortJqlGenerator sortJqlGenerator;
    private final JqlQueryParser jqlQueryParser;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final FilterLookerUpper filterLookerUpper;
    private final OrderByUtil orderByUtil;

    public OrderByOptionsResource(FieldManager fieldManager, JqlQueryParser jqlQueryParser, SortJqlGenerator sortJqlGenerator, JiraAuthenticationContext jiraAuthenticationContext, FilterLookerUpper filterLookerUpper, OrderByUtil orderByUtil) {
        this.fieldManager = fieldManager;
        this.jqlQueryParser = jqlQueryParser;
        this.sortJqlGenerator = sortJqlGenerator;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.filterLookerUpper = filterLookerUpper;
        this.orderByUtil = orderByUtil;
    }

    @POST
    public OrderByOptions getOrderByOptions(OrderByRequest request) {
        int effectiveMaxResults = Math.min(request.maxResults, 50);
        try {
            SuggestedFields fields;
            Query query = this.getQuery(request.jql, request.filter);
            SuggestedFields matchingFields = fields = new SuggestedFields(this.getSortableColumns());
            if (StringUtils.isNotBlank((String)request.query)) {
                matchingFields = matchingFields.filterBy(new FieldNameStartsWith(request.query));
            }
            if (StringUtils.isNotBlank((String)request.sortBy)) {
                matchingFields = matchingFields.filterBy(new FieldIdIsNot(request.sortBy));
            }
            SuggestedFields topMatchingFields = matchingFields.sortBy(new NameComparator(this.jiraAuthenticationContext.getI18nHelper())).selectTop(effectiveMaxResults);
            List<OrderByOption> orderOptions = this.buildOrderOptions((List<NavigableField>)topMatchingFields.fields, query);
            return new OrderByOptions().fields(orderOptions).totalCount(fields.size()).matchesCount(matchingFields.size()).maxResults(effectiveMaxResults);
        }
        catch (JqlParseException e) {
            throw new RuntimeException("Error parsing JQL: " + request.jql, e);
        }
    }

    @POST
    @Path(value="primary")
    public SortByBean getPrimary(OrderByRequest request) {
        try {
            Query query = this.getQuery(request.jql, request.filter);
            return this.orderByUtil.generateSortBy(query);
        }
        catch (JqlParseException e) {
            throw new RuntimeException("Error parsing JQL: " + request.jql, e);
        }
    }

    private Query getQuery(String jql, String filter) throws JqlParseException {
        SimpleErrorCollection errors;
        SearchRequest searchRequest;
        if (StringUtils.isNotBlank((String)jql)) {
            return this.jqlQueryParser.parseQuery(jql);
        }
        if (StringUtils.isNotBlank((String)filter) && (searchRequest = this.filterLookerUpper.getSearchRequestFromFilterId(filter, (ErrorCollection)(errors = new SimpleErrorCollection()))) != null) {
            return searchRequest.getQuery();
        }
        return JqlQueryBuilder.newBuilder().buildQuery();
    }

    private Collection<NavigableField> getSortableColumns() {
        try {
            ArrayList navigableFields = Lists.newArrayList((Iterable)this.fieldManager.getAvailableNavigableFields(this.jiraAuthenticationContext.getLoggedInUser()));
            return Collections2.filter((Collection)navigableFields, (Predicate)new FieldIsSortable());
        }
        catch (FieldException e) {
            throw new RuntimeException("Error getting all navigable fields");
        }
    }

    private List<OrderByOption> buildOrderOptions(List<NavigableField> fields, Query query) {
        if (fields == null || fields.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, String> sortJql = this.sortJqlGenerator.generateColumnSortJql(query, fields);
        ArrayList orderOptions = Lists.newArrayListWithCapacity((int)fields.size());
        for (NavigableField field : fields) {
            if (!sortJql.containsKey(field.getId())) continue;
            orderOptions.add(new OrderByOption().fieldId(field.getId()).fieldName(field.getName()).sortJql(sortJql.get(field.getId())));
        }
        return orderOptions;
    }

    private static class FieldIdIsNot
    implements Predicate<Field> {
        private final String fieldId;

        public FieldIdIsNot(@Nonnull String fieldId) {
            this.fieldId = (String)Preconditions.checkNotNull((Object)fieldId);
        }

        public boolean apply(@Nullable Field field) {
            return field != null && !this.fieldId.equals(field.getId());
        }
    }

    private class FieldIsSortable
    implements Predicate<NavigableField> {
        private FieldIsSortable() {
        }

        public boolean apply(@Nullable NavigableField field) {
            return field != null && field.getSorter() != null;
        }
    }

    private class FieldNameStartsWith
    implements Predicate<Field> {
        private final String prefix;

        private FieldNameStartsWith(String prefix) {
            this.prefix = ((String)Preconditions.checkNotNull((Object)prefix)).toLowerCase();
        }

        public boolean apply(@Nullable Field field) {
            return field != null && field.getName() != null && field.getName().toLowerCase().startsWith(this.prefix);
        }
    }

    class SuggestedFields {
        private final ImmutableList<NavigableField> fields;

        public SuggestedFields(Collection<NavigableField> fields) {
            this.fields = ImmutableList.copyOf(fields);
        }

        public int size() {
            return this.fields.size();
        }

        public SuggestedFields filterBy(Predicate<? super NavigableField> predicate) {
            return new SuggestedFields(Collections2.filter(this.fields, predicate));
        }

        public SuggestedFields sortBy(Comparator<Field> comparator) {
            ArrayList ranked = Lists.newArrayList(this.fields);
            Collections.sort(ranked, comparator);
            return new SuggestedFields(ranked);
        }

        public SuggestedFields selectTop(int maxResults) {
            return new SuggestedFields((Collection<NavigableField>)this.fields.subList(0, Math.min(this.fields.size(), maxResults)));
        }
    }
}

