/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.orderby;

import com.atlassian.jira.components.orderby.OrderByUtil;
import com.atlassian.jira.components.orderby.SortByBean;
import com.atlassian.jira.components.util.SortJqlGenerator;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.query.Query;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SearchSort;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;

@ExportAsService
@Named
public class DefaultOrderByUtil
implements OrderByUtil {
    private SearchHandlerManager searchHandlerManager;
    private FieldManager fieldManager;
    private final SortJqlGenerator sortJqlGenerator;

    @Inject
    public DefaultOrderByUtil(SearchHandlerManager searchHandlerManager, FieldManager fieldManager, SortJqlGenerator sortJqlGenerator) {
        this.searchHandlerManager = searchHandlerManager;
        this.fieldManager = fieldManager;
        this.sortJqlGenerator = sortJqlGenerator;
    }

    @Override
    public SortByBean generateSortBy(Query query) {
        SearchSort searchSort;
        Collection fieldIds;
        List searchSorts;
        OrderBy orderByClause = query.getOrderByClause();
        if (orderByClause != null && (searchSorts = orderByClause.getSearchSorts()).size() > 0 && !(fieldIds = this.searchHandlerManager.getFieldIds((searchSort = (SearchSort)searchSorts.get(0)).getField())).isEmpty()) {
            String fieldId = (String)fieldIds.iterator().next();
            Field field = this.fieldManager.getField(fieldId);
            String order = searchSort.getOrder();
            if (order == null || order.isEmpty()) {
                order = field instanceof NavigableField ? ((NavigableField)field).getDefaultSortOrder() : "ASC";
            }
            String sortJql = null;
            if (field instanceof NavigableField) {
                sortJql = this.sortJqlGenerator.generateColumnSortJql(query, Lists.newArrayList((Object[])new NavigableField[]{(NavigableField)field})).get(fieldId);
            }
            return new SortByBean(field.getId(), field.getName(), order, sortJql);
        }
        return null;
    }
}

