/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.issueviewer.viewissue.webpanel;

import com.atlassian.jira.components.issueeditor.action.ContentIdCollector;
import com.atlassian.jira.components.issueviewer.viewissue.IssueOperationLinksProvider;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.ContentRenderingInstructionProvider;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.IssueWebPanelsBean;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.WebPanelBean;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.WebPanelBeanBuilder;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.WebPanelMapperUtil;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.util.IssueWebPanelRenderUtil;
import com.atlassian.jira.rest.v2.common.SimpleLinkBean;
import com.atlassian.jira.rest.v2.issue.LinkGroupBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.component.ContentRenderingInstruction;
import com.atlassian.jira.web.component.ModuleWebComponent;
import com.atlassian.jira.web.component.ModuleWebComponentFields;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import webwork.action.Action;

@ExportAsService
@Named
public class WebPanelMapperUtilImpl
implements WebPanelMapperUtil {
    private final WebInterfaceManager webInterfaceManager;
    private final ModuleWebComponentFields moduleWebComponentFields;
    private final JiraAuthenticationContext authenticationContext;
    private final ModuleWebComponent moduleWebComponent;
    private final ContentRenderingInstructionProvider contentRenderingInstructionProvider;

    @Inject
    public WebPanelMapperUtilImpl(WebInterfaceManager webInterfaceManager, ModuleWebComponentFields moduleWebComponentFields, JiraAuthenticationContext authenticationContext, ModuleWebComponent moduleWebComponent, ContentRenderingInstructionProvider contentRenderingInstructionProvider) {
        this.webInterfaceManager = webInterfaceManager;
        this.moduleWebComponentFields = moduleWebComponentFields;
        this.authenticationContext = authenticationContext;
        this.moduleWebComponent = moduleWebComponent;
        this.contentRenderingInstructionProvider = contentRenderingInstructionProvider;
    }

    @Override
    public IssueWebPanelsBean create(Issue issue, Action action) {
        return this.create(issue, action, null);
    }

    @Override
    public IssueWebPanelsBean create(Issue issue, Action action, ContentIdCollector contentIdCollector) {
        IssueWebPanelRenderUtil issueWebPanelRenderUtil = new IssueWebPanelRenderUtil(this.authenticationContext.getLoggedInUser(), issue, action, this.webInterfaceManager, this.moduleWebComponent);
        if (contentIdCollector != null && contentIdCollector.getLastReadTime() != null) {
            issueWebPanelRenderUtil.getWebPanelContext().put("lastReadTime", new Date(contentIdCollector.getLastReadTime()));
        }
        List<WebPanelBean> leftPanels = this.mapAndRenderPanels(issueWebPanelRenderUtil, issueWebPanelRenderUtil.getLeftWebPanels(), contentIdCollector);
        List<WebPanelBean> rightPanels = this.mapAndRenderPanels(issueWebPanelRenderUtil, issueWebPanelRenderUtil.getRightWebPanels(), contentIdCollector);
        List<WebPanelBean> infoPanels = this.mapAndRenderPanels(issueWebPanelRenderUtil, issueWebPanelRenderUtil.getInfoWebPanels(), contentIdCollector);
        return new IssueWebPanelsBean(leftPanels, rightPanels, infoPanels);
    }

    List<WebPanelBean> mapAndRenderPanels(IssueWebPanelRenderUtil issueWebPanelRenderUtil, List<WebPanelModuleDescriptor> webPanels, ContentIdCollector contentIdCollector) {
        ArrayList<WebPanelBean> panels = new ArrayList<WebPanelBean>();
        if (contentIdCollector == null) {
            for (WebPanelModuleDescriptor webPanel : webPanels) {
                WebPanelBean bean = this.getWebPanelBeanBuilder(issueWebPanelRenderUtil, webPanel).buildWithHtml();
                if (bean == null) continue;
                panels.add(bean);
            }
        } else {
            boolean loadAll = contentIdCollector.mustLoadAll();
            for (WebPanelModuleDescriptor webPanel : webPanels) {
                WebPanelBean bean = this.getWebPanelBeanBuilder(issueWebPanelRenderUtil, webPanel).buildWithoutHtml();
                boolean render = true;
                String currentContentId = contentIdCollector.getCurrentPanelContentId(webPanel.getCompleteKey());
                String newContentId = null;
                ContentRenderingInstruction instruction = this.contentRenderingInstructionProvider.get(issueWebPanelRenderUtil.getWebPanelContext(), webPanel);
                if (instruction != null) {
                    if (instruction.isDontRender() && currentContentId != null) {
                        render = false;
                        newContentId = currentContentId;
                    } else if (!instruction.isRenderHtml() && instruction.getContentId() != null) {
                        newContentId = this.calculateFullContentId(instruction.getContentId(), bean, contentIdCollector);
                        if (!loadAll && newContentId.equals(currentContentId)) {
                            render = false;
                        }
                    }
                }
                if (render) {
                    String panelHtml = issueWebPanelRenderUtil.renderHeadlessPanel(webPanel);
                    if (!StringUtils.isNotBlank((String)panelHtml)) continue;
                    bean = new WebPanelBean.Builder(bean).html(panelHtml).build();
                    boolean addPanel = true;
                    if (newContentId == null) {
                        newContentId = this.calculateFullContentId(panelHtml, bean, contentIdCollector);
                        if (!loadAll && newContentId.equals(currentContentId)) {
                            addPanel = false;
                        }
                    }
                    if (addPanel) {
                        bean.setContentId(newContentId);
                        panels.add(bean);
                    }
                    contentIdCollector.addNewPanelKey(bean.getCompleteKey());
                    continue;
                }
                contentIdCollector.addNewPanelKey(bean.getCompleteKey());
            }
        }
        return panels;
    }

    private String calculateFullContentId(String contentId, WebPanelBean bean, ContentIdCollector contentIdCollector) {
        String calculateFrom = this.getCalculateFrom(contentId, bean);
        return contentIdCollector.calculateContentId(calculateFrom);
    }

    String getCalculateFrom(String contentId, WebPanelBean bean) {
        StringBuilder builder = new StringBuilder(contentId);
        builder.append(bean.getLabel()).append(bean.getPrefix()).append(bean.getStyleClass()).append(bean.isRenderHeader()).append(bean.getWeight());
        this.appendGroup(bean.getHeaderLinks(), builder);
        for (String subPanelHtml : bean.getSubpanelHtmls()) {
            builder.append(subPanelHtml);
        }
        return builder.toString();
    }

    private void appendGroup(LinkGroupBean group, StringBuilder builder) {
        if (group == null) {
            return;
        }
        builder.append(group.getStyleClass()).append(group.getWeight());
        this.appendLink(group, group.getHeader(), builder);
        for (SimpleLinkBean link : group.getLinks()) {
            this.appendLink(group, link, builder);
        }
        for (LinkGroupBean subGroup : group.getGroups()) {
            this.appendGroup(subGroup, builder);
        }
    }

    private void appendLink(LinkGroupBean group, SimpleLinkBean link, StringBuilder builder) {
        String value = IssueOperationLinksProvider.getLinkValueForContentIdCalculation(group, link);
        if (value != null) {
            builder.append(value);
        }
    }

    WebPanelBeanBuilder getWebPanelBeanBuilder(IssueWebPanelRenderUtil issueWebPanelRenderUtil, WebPanelModuleDescriptor webPanel) {
        return new WebPanelBeanBuilder(this.moduleWebComponentFields, issueWebPanelRenderUtil, this.authenticationContext.getI18nHelper(), this.authenticationContext.getLoggedInUser(), webPanel);
    }
}

