/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.issueviewer.viewissue.webpanel;

import com.atlassian.jira.components.issueviewer.viewissue.webpanel.WebPanelBean;
import com.atlassian.jira.issue.util.IssueWebPanelRenderUtil;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.rest.v2.common.SimpleLinkBean;
import com.atlassian.jira.rest.v2.issue.LinkGroupBean;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.component.ModuleWebComponentFields;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebLabel;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WebPanelBeanBuilder {
    private final ModuleWebComponentFields moduleWebComponentFields;
    private final IssueWebPanelRenderUtil renderUtil;
    private final I18nHelper i18n;
    private final ApplicationUser user;
    private final WebPanelModuleDescriptor panel;

    public WebPanelBeanBuilder(ModuleWebComponentFields moduleWebComponentFields, IssueWebPanelRenderUtil renderUtil, I18nHelper i18n, ApplicationUser user, WebPanelModuleDescriptor panel) {
        this.moduleWebComponentFields = moduleWebComponentFields;
        this.renderUtil = renderUtil;
        this.i18n = i18n;
        this.user = user;
        this.panel = panel;
    }

    public WebPanelBean buildWithHtml() {
        String panelHtml = this.renderUtil.renderHeadlessPanel(this.panel);
        if (StringUtils.isNotBlank((String)panelHtml)) {
            return this.builder().html(panelHtml).build();
        }
        return null;
    }

    public WebPanelBean buildWithoutHtml() {
        return this.builder().build();
    }

    private WebPanelBean.Builder builder() {
        Map moduleParams = this.panel.getParams();
        boolean headless = moduleParams.containsKey("headless");
        String styleClass = moduleParams.containsKey("containerClass") ? (String)moduleParams.get("containerClass") : "";
        return new WebPanelBean.Builder().completeKey(this.panel.getCompleteKey()).prefix(this.getPrefix()).id(this.panel.getKey()).styleClass(styleClass).label(this.getLabel()).renderHeader(!headless).headerLinks(this.getHeaderLinks()).subpanelHtmls(this.getSubpanelHtmls()).weight(this.panel.getWeight());
    }

    private String getLabel() {
        try {
            WebLabel webLabel = this.panel.getWebLabel();
            if (webLabel != null) {
                return webLabel.getDisplayableLabel(ExecutingHttpRequest.get(), this.renderUtil.getWebPanelContext());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.panel.getI18nNameKey() != null) {
            return this.i18n.getText(this.panel.getI18nNameKey());
        }
        return this.panel.getKey();
    }

    private List<String> getSubpanelHtmls() {
        ArrayList<String> ret = new ArrayList<String>();
        List panels = this.moduleWebComponentFields.getPanels(this.panel.getCompleteKey(), this.renderUtil.getWebPanelContext());
        if (!panels.isEmpty()) {
            for (WebPanelModuleDescriptor panel : panels) {
                String panelHtml = ((WebPanel)panel.getModule()).getHtml(this.renderUtil.getWebPanelContext());
                if (!StringUtils.isNotBlank((String)panelHtml)) continue;
                ret.add(panelHtml);
            }
        }
        return ret;
    }

    private LinkGroupBean getHeaderLinks() {
        List headerItems = this.moduleWebComponentFields.getHeaderItems(this.panel.getCompleteKey(), this.user, this.getHelper());
        List<LinkGroupBean> dropdownGroups = this.getGroups(this.panel.getCompleteKey());
        return new LinkGroupBean.Builder().addLinks(this.toBeans(headerItems)).addGroups(dropdownGroups).build();
    }

    private List<LinkGroupBean> getGroups(String key) {
        return Lists.transform((List)this.moduleWebComponentFields.getDropdownSections(key, this.user, this.getHelper()), (Function)new Function<ModuleWebComponentFields.SectionsAndLinks, LinkGroupBean>(){

            public LinkGroupBean apply(ModuleWebComponentFields.SectionsAndLinks o) {
                return new LinkGroupBean.Builder().header(WebPanelBeanBuilder.this.toBean(o.getSection())).addLinks(WebPanelBeanBuilder.this.toBeans(o.getLinks())).build();
            }
        });
    }

    private SimpleLinkBean toBean(SimpleLinkSection simpleLinkSection) {
        return new SimpleLinkBean(simpleLinkSection.getId(), simpleLinkSection.getStyleClass(), simpleLinkSection.getLabel(), simpleLinkSection.getTitle(), null, simpleLinkSection.getStyleClass(), simpleLinkSection.getWeight());
    }

    private List<SimpleLinkBean> toBeans(List<SimpleLink> input) {
        ArrayList<SimpleLinkBean> ret = new ArrayList<SimpleLinkBean>();
        for (SimpleLink simpleLink : input) {
            ret.add(new SimpleLinkBean(simpleLink));
        }
        return ret;
    }

    private String getPrefix() {
        String prefix = (String)this.panel.getParams().get("prefix");
        return prefix == null ? "" : prefix;
    }

    public JiraHelper getHelper() {
        return (JiraHelper)this.renderUtil.getWebPanelContext().get("helper");
    }
}

