/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.issueviewer.viewissue.webpanel;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.IssueWebPanelsBean;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.WebPanelMapperUtil;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugins.rest.common.json.DefaultJaxbJsonMarshaller;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import webwork.action.Action;
import webwork.action.ActionContext;

public class ViewIssueWebPanels
extends JiraWebActionSupport
implements OperationContext {
    private Long id;
    private final IssueService issueService;
    private final WebPanelMapperUtil webPanelMapperUtil;
    private ErrorCollection errors;
    private IssueWebPanelsBean issueWebPanelsBean;

    public ViewIssueWebPanels(IssueService issueService, WebPanelMapperUtil webPanelMapperUtil) {
        this.issueService = issueService;
        this.webPanelMapperUtil = webPanelMapperUtil;
    }

    public String doDefault() throws Exception {
        ActionContext.getResponse().setContentType("application/json");
        IssueService.IssueResult result = this.issueService.getIssue(this.getLoggedInUser(), this.id);
        if (!result.isValid()) {
            this.errors = ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection());
            ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)result.getErrorCollection().getReasons());
            ActionContext.getResponse().setStatus(worstReason == null ? 400 : worstReason.getHttpStatusCode());
            return this.JSON();
        }
        this.issueWebPanelsBean = this.webPanelMapperUtil.create((Issue)result.getIssue(), (Action)this);
        return this.JSON();
    }

    private String JSON() throws IOException {
        ActionContext.getResponse().getWriter().append(this.getJson());
        return null;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getJson() {
        DefaultJaxbJsonMarshaller marshaller = new DefaultJaxbJsonMarshaller();
        Object objectToMarshall = this.errors != null ? this.errors : this.issueWebPanelsBean;
        return marshaller.marshal(objectToMarshall);
    }

    public Map getFieldValuesHolder() {
        return new HashMap();
    }

    public IssueOperation getIssueOperation() {
        return IssueOperations.EDIT_ISSUE_OPERATION;
    }
}

