/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.issueviewer.util;

import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.UserAgentUtil;
import com.atlassian.jira.util.UserAgentUtilImpl;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class HashTransformer {
    private static final Pattern HASH_URL_PATTERN = Pattern.compile(".*/i($|\\?.*)");
    private static final String HASH_URL_ROOT = "/i";
    private static final List<String> PARAMETER_WHITE_LIST = Lists.newArrayList((Object[])new String[]{"jwupdated", "quickSearchQuery"});

    public boolean supportsPushState(String userAgent) {
        UserAgentUtil.Browser browser = new UserAgentUtilImpl().getUserAgentInfo(userAgent).getBrowser();
        UserAgentUtil.BrowserMajorVersion version = browser.getBrowserMajorVersion();
        return !UserAgentUtil.BrowserMajorVersion.MSIE8.equals((Object)version) && !UserAgentUtil.BrowserMajorVersion.MSIE9.equals((Object)version) && !UserAgentUtil.BrowserMajorVersion.SAFARI32.equals((Object)version) && !UserAgentUtil.BrowserMajorVersion.SAFARI4.equals((Object)version) && !UserAgentUtil.BrowserMajorVersion.SAFARI41.equals((Object)version) && !UserAgentUtil.BrowserMajorVersion.OPERAMINI5.equals((Object)version) && !UserAgentUtil.BrowserMajorVersion.OPERAMINI6.equals((Object)version) && !UserAgentUtil.BrowserMajorVersion.OPERAMINI7.equals((Object)version) && !UserAgentUtil.BrowserMajorVersion.ANDROID21.equals((Object)version) && !UserAgentUtil.BrowserMajorVersion.ANDROID3.equals((Object)version) && !UserAgentUtil.BrowserMajorVersion.ANDROID4.equals((Object)version) && !UserAgentUtil.BrowserMajorVersion.ANDROID41.equals((Object)version);
    }

    public boolean isHashedUrl(String URL2) {
        return URL2 != null && HASH_URL_PATTERN.matcher(URL2).matches();
    }

    public String transformURL(String URL2, Map<String, String[]> parameters) {
        if (parameters == null && URL2 == null) {
            return "";
        }
        String URLAsFragment = URL2.startsWith("/") ? URL2.replaceFirst("/", "#") : "#" + URL2;
        UrlBuilder realQueryString = new UrlBuilder(false);
        UrlBuilder fragmentQueryString = new UrlBuilder(false);
        if (URL2 != null && (parameters == null || parameters.size() == 0)) {
            return HASH_URL_ROOT + URLAsFragment;
        }
        for (String key : parameters.keySet()) {
            if (PARAMETER_WHITE_LIST.contains(key)) {
                this.addParameter(realQueryString, key, parameters.get(key));
                continue;
            }
            this.addParameter(fragmentQueryString, key, parameters.get(key));
        }
        String query = realQueryString.asUrlString();
        String fragment = fragmentQueryString.asUrlString();
        return HASH_URL_ROOT + query + URLAsFragment + fragment;
    }

    protected void addParameter(UrlBuilder urlBuilder, String key, String[] values) {
        for (String value : values) {
            urlBuilder.addParameter(key, value);
        }
    }
}

