/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.issueviewer.service;

import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import com.atlassian.query.order.SortOrder;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public enum SystemFilter {
    MY_OPEN_ISSUES(-1L, "issue.nav.filters.my.open.issues", "assignee = currentUser() AND resolution = Unresolved", Arrays.asList(Flags.REQUIRES_LOGIN, Flags.SUPPORTS_INLINE_ISSUE_CREATE), Arrays.asList("assignee", "resolution"), new SearchSort("updated", SortOrder.DESC)),
    REPORTED_BY_ME(-2L, "issue.nav.filters.reported.by.me", "reporter = currentUser()", Arrays.asList(Flags.REQUIRES_LOGIN, Flags.SUPPORTS_INLINE_ISSUE_CREATE), Collections.singletonList("reporter"), new SearchSort("created", SortOrder.DESC)),
    ALL_ISSUES(-4L, "issue.nav.filters.all.issues", null, Collections.singletonList(Flags.SUPPORTS_INLINE_ISSUE_CREATE), Collections.emptyList(), new SearchSort("created", SortOrder.DESC)),
    ALL_OPEN_ISSUES(-5L, "issue.nav.filters.open.issues", "resolution = Unresolved", Collections.singletonList(Flags.SUPPORTS_INLINE_ISSUE_CREATE), Collections.singletonList("resolution"), new SearchSort("priority", SortOrder.DESC), new SearchSort("updated", SortOrder.DESC)),
    DONE_ISSUES(-9L, "issue.nav.filters.done.issues", "statusCategory = Done", Collections.emptyList(), Collections.singletonList("status"), new SearchSort("updated", SortOrder.DESC)),
    RECENTLY_VIEWED(-3L, "issue.nav.filters.recently.viewed", "issuekey in issueHistory()", Collections.singletonList(Flags.SUPPORTS_INLINE_ISSUE_CREATE), Collections.singletonList("issuekey"), new SearchSort("lastViewed", SortOrder.DESC)),
    ADDED_RECENTLY(-6L, "issue.nav.filters.created.recently", "created >= -1w", Collections.singletonList(Flags.SUPPORTS_INLINE_ISSUE_CREATE), Collections.singletonList("created"), new SearchSort("created", SortOrder.DESC)),
    RESOLVED_RECENTLY(-7L, "common.filters.resolvedrecently", "resolutiondate >= -1w", Collections.emptyList(), Collections.singletonList("resolutiondate"), new SearchSort("updated", SortOrder.DESC)),
    UPDATED_RECENTLY(-8L, "common.filters.updatedrecently", "updated >= -1w", Collections.singletonList(Flags.SUPPORTS_INLINE_ISSUE_CREATE), Collections.singletonList("updated"), new SearchSort("updated", SortOrder.DESC));

    private static final Map<Long, SystemFilter> SYSTEM_FILTER_MAP;
    private final Long id;
    private final String name;
    private final String whereClause;
    private final List<String> fields;
    private final boolean requiresLogin;
    private final boolean supportsInlineIssueCreate;
    private final OrderBy orderBy;

    private SystemFilter(Long id, String name, String whereClause, List<Flags> flags, List<String> fields, SearchSort ... searchSort) {
        this.id = id;
        this.name = name;
        this.whereClause = whereClause;
        this.orderBy = new OrderByImpl(searchSort);
        this.fields = fields;
        this.requiresLogin = flags.contains((Object)Flags.REQUIRES_LOGIN);
        this.supportsInlineIssueCreate = flags.contains((Object)Flags.SUPPORTS_INLINE_ISSUE_CREATE);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getJql() {
        StringBuilder sb = new StringBuilder();
        if (this.whereClause != null) {
            sb.append(this.whereClause).append(" ");
        }
        sb.append(this.orderBy);
        return sb.toString();
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public boolean isRequiresLogin() {
        return this.requiresLogin;
    }

    public boolean isSupportsInlineIssueCreate() {
        return this.supportsInlineIssueCreate;
    }

    public static boolean isSystemFilter(Long id) {
        return SystemFilter.getSystemFilterById(id) != null;
    }

    public static SystemFilter getSystemFilterById(Long id) {
        return SYSTEM_FILTER_MAP.get(id);
    }

    static {
        SYSTEM_FILTER_MAP = Maps.uniqueIndex(Arrays.asList(SystemFilter.values()), SystemFilter::getId);
    }

    static enum Flags {
        REQUIRES_LOGIN,
        SUPPORTS_INLINE_ISSUE_CREATE;

    }
}

