/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.issueviewer.action;

import com.atlassian.analytics.api.annotations.Analytics;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.components.issueeditor.action.ActionUtils;
import com.atlassian.jira.components.issueeditor.action.BaseEditAction;
import com.atlassian.jira.components.issueeditor.action.DefaultContentIdCollector;
import com.atlassian.jira.components.issueviewer.action.IssueBean;
import com.atlassian.jira.components.issueviewer.action.IssueFields;
import com.atlassian.jira.components.issueviewer.service.ActionUtilsService;
import com.atlassian.jira.components.issueviewer.service.SessionSearchService;
import com.atlassian.jira.components.issueviewer.viewissue.IssueFieldProvider;
import com.atlassian.jira.components.issueviewer.viewissue.IssueOperationLinksProvider;
import com.atlassian.jira.components.issueviewer.viewissue.IssueSummaryProvider;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.IssueWebPanelsBean;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.WebPanelMapperUtil;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.rest.IssueFinder;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.OpsbarBean;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.issue.IssueMetadataHelper;
import com.atlassian.plugins.rest.common.json.DefaultJaxbJsonMarshaller;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.ResultException;

public class AjaxIssueAction
extends BaseEditAction {
    private static final Logger log = Logger.getLogger(AjaxIssueAction.class);
    private final EventPublisher eventPublisher;
    private final IssueFinder issueFinder;
    private final IssueMetadataHelper issueMetadataHelper;
    private final SessionSearchService sessionSearchService;
    private final UserIssueHistoryManager userIssueHistoryManager;
    private final WebPanelMapperUtil webPanelMapperUtil;
    private final ActionUtilsService actionUtilsService;
    private final IssueOperationLinksProvider issueOperationLinksProvider;
    private final IssueSummaryProvider issueSummaryProvider;
    private boolean singleFieldEdit = false;
    private boolean prefetch = false;
    private boolean loadFields = true;
    private boolean skipScreenCheck = false;
    private boolean shouldUpdateCurrentProject = true;
    private IssueService.UpdateValidationResult updateValidationResult;
    private IssueFields fields;

    public AjaxIssueAction(EventPublisher eventPublisher, IssueFinder issueFinder, IssueMetadataHelper issueMetadataHelper, IssueService issueService, SessionSearchService sessionSearchService, UserIssueHistoryManager userIssueHistoryManager, WebPanelMapperUtil webPanelMapperUtil, ActionUtilsService actionUtilsService, IssueFieldProvider issueFieldProvider, IssueOperationLinksProvider issueOperationLinksProvider, IssueSummaryProvider issueSummaryProvider) {
        super(issueService, issueFieldProvider);
        this.eventPublisher = eventPublisher;
        this.issueFinder = issueFinder;
        this.issueMetadataHelper = issueMetadataHelper;
        this.sessionSearchService = sessionSearchService;
        this.userIssueHistoryManager = userIssueHistoryManager;
        this.webPanelMapperUtil = webPanelMapperUtil;
        this.actionUtilsService = actionUtilsService;
        this.issueOperationLinksProvider = issueOperationLinksProvider;
        this.issueSummaryProvider = issueSummaryProvider;
    }

    public String doDefault() throws Exception {
        ActionContext.getResponse().setContentType("application/json");
        String idOrKey = null;
        if (this.issueId != null) {
            idOrKey = Long.toString(this.issueId);
        } else if (this.issueKey != null) {
            idOrKey = this.issueKey;
        }
        SimpleErrorCollection errors = new SimpleErrorCollection();
        MutableIssue issue = (MutableIssue)this.issueFinder.findIssue(idOrKey, (com.atlassian.jira.util.ErrorCollection)errors);
        IssueService.IssueResult result = new IssueService.IssueResult(issue, (com.atlassian.jira.util.ErrorCollection)errors);
        if (!result.isValid() || result.getIssue() == null) {
            ErrorCollection errorCollection = ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection());
            this.fields = new IssueFields(this.getXsrfToken(), errorCollection);
            ActionContext.getResponse().setStatus(errorCollection.getStatus().intValue());
            return this.JSON();
        }
        this.tagMauEventWithProject(issue.getProjectObject());
        if (!this.isPrefetch()) {
            this.userIssueHistoryManager.addIssueToHistory(this.getLoggedInUser(), (Issue)issue);
            if (this.shouldUpdateCurrentProject()) {
                this.setSelectedProjectId(issue.getProjectObject().getId());
            }
        }
        this.populateIssueFields((Issue)issue, false, ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection()));
        return this.JSON();
    }

    private void populateIssueFields(Issue issue, boolean retainValues, ErrorCollection errorCollection) {
        DefaultContentIdCollector contentIdCollector = this.createContentIdCollector();
        long start = System.nanoTime();
        boolean isEditable = this.issueService.isEditable(issue, this.getLoggedInUser());
        List<Object> editFields = this.loadFields && isEditable ? this.issueFieldProvider.getEditFields(this.getLoggedInUser(), this, (Action)this, issue, retainValues, contentIdCollector) : Collections.emptyList();
        long fieldEnd = System.nanoTime();
        OpsbarBean opsbarBean = this.issueOperationLinksProvider.getOperations(issue, contentIdCollector);
        Map metadata = this.issueMetadataHelper.getMetadata(issue, this.sessionSearchService.getSessionSearch());
        IssueSummaryProvider.Result summaryCheckResult = this.issueSummaryProvider.check(issue, contentIdCollector);
        IssueBean issueBean = new IssueBean(issue, metadata, opsbarBean, issue.getProjectObject(), issue.getStatusObject(), summaryCheckResult.newContentId, summaryCheckResult.changed, isEditable);
        long issueEnd = System.nanoTime();
        IssueWebPanelsBean panels = this.webPanelMapperUtil.create(issue, (Action)this, contentIdCollector);
        long panelsEnd = System.nanoTime();
        this.eventPublisher.publish((Object)new IssueRenderTime(fieldEnd - start, issueEnd - fieldEnd, panelsEnd - issueEnd));
        this.fields = new IssueFields(this.getXsrfToken(), errorCollection, editFields, issueBean, null, panels, contentIdCollector.getRemovedContentIds());
    }

    protected void doValidation() {
        ActionContext.getResponse().setContentType("application/json");
        IssueService.IssueResult result = this.issueService.getIssue(this.getLoggedInUser(), this.issueId);
        MutableIssue issue = result.getIssue();
        if (!result.isValid() || result.getIssue() == null) {
            this.addErrorCollection(result.getErrorCollection());
            this.fields = new IssueFields(this.getXsrfToken(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection()));
            ActionUtils.setErrorReturnCode(this.getLoggedInUser());
            this.JSON();
            return;
        }
        IssueInputParametersImpl issueInputParameters = new IssueInputParametersImpl(ActionContext.getParameters());
        if (this.singleFieldEdit) {
            issueInputParameters.setRetainExistingValuesWhenParameterNotProvided(this.singleFieldEdit, true);
        }
        if (this.skipScreenCheck) {
            issueInputParameters.setSkipScreenCheck(true);
        }
        this.updateValidationResult = this.issueService.validateUpdate(this.getLoggedInUser(), issue.getId(), (IssueInputParameters)issueInputParameters);
        this.setFieldValuesHolder(this.updateValidationResult.getFieldValuesHolder());
        if (!this.updateValidationResult.isValid()) {
            com.atlassian.jira.util.ErrorCollection errors = this.updateValidationResult.getErrorCollection();
            this.addErrorCollection(errors);
            this.populateIssueFields((Issue)issue, true, ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errors));
            ActionUtils.setErrorReturnCode(this.getLoggedInUser());
            this.JSON();
        }
    }

    protected void validate() throws ResultException {
        this.doValidation();
        if (this.invalidInput()) {
            throw new ResultException("none");
        }
    }

    private String JSON() {
        try {
            ActionContext.getResponse().getWriter().append(this.getJson());
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        try {
            IssueService.IssueResult result = this.issueService.update(this.getLoggedInUser(), this.updateValidationResult);
            if (!result.isValid()) {
                this.addErrorCollection(result.getErrorCollection());
                this.populateIssueFields((Issue)this.updateValidationResult.getIssue(), true, ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection()));
                ActionUtils.setErrorReturnCode(this.getLoggedInUser());
                return this.JSON();
            }
            result = this.issueService.getIssue(this.getLoggedInUser(), this.getIssueId());
            MutableIssue issue = result.getIssue();
            if (!result.isValid()) {
                this.addErrorCollection(result.getErrorCollection());
                this.fields = new IssueFields(this.getXsrfToken(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection()));
                ActionUtils.setErrorReturnCode(this.getLoggedInUser());
                return this.JSON();
            }
            this.tagMauEventWithProject(issue.getProjectObject());
            this.userIssueHistoryManager.addIssueToHistory(this.getLoggedInUser(), (Issue)issue);
            this.populateIssueFields((Issue)issue, false, ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection()));
            return this.JSON();
        }
        catch (Throwable e) {
            this.addErrorMessage(this.getText("admin.errors.issues.exception.occured", e));
            log.error((Object)("Exception occurred editing issue: " + e), e);
            this.fields = new IssueFields(this.getXsrfToken(), ErrorCollection.of((String[])new String[]{this.getText("admin.errors.issues.exception.occured", e)}));
            ActionContext.getResponse().setStatus(400);
            return this.JSON();
        }
    }

    public String getJson() {
        DefaultJaxbJsonMarshaller marshaller = new DefaultJaxbJsonMarshaller();
        return marshaller.marshal((Object)this.fields);
    }

    public boolean isSingleFieldEdit() {
        return this.singleFieldEdit;
    }

    public void setSingleFieldEdit(boolean singleFieldEdit) {
        this.singleFieldEdit = singleFieldEdit;
    }

    public boolean isPrefetch() {
        return this.prefetch;
    }

    public void setPrefetch(boolean prefetch) {
        this.prefetch = prefetch;
    }

    public void setLoadFields(boolean loadFields) {
        this.loadFields = loadFields;
    }

    public void setSkipScreenCheck(boolean skipScreenCheck) {
        this.skipScreenCheck = skipScreenCheck;
    }

    public void setShouldUpdateCurrentProject(boolean shouldUpdateCurrentProject) {
        this.shouldUpdateCurrentProject = shouldUpdateCurrentProject;
    }

    public boolean shouldUpdateCurrentProject() {
        return this.shouldUpdateCurrentProject;
    }

    @Analytics(value="kickass.issueRenderTime")
    public static class IssueRenderTime {
        public final double fieldsTimeMs;
        public final double issueTimeMs;
        public final double panelsTimeMs;

        public IssueRenderTime(long fieldsTimeNano, long issueTimeNano, long panelsTimeNano) {
            this.fieldsTimeMs = (double)fieldsTimeNano / 1000000.0;
            this.issueTimeMs = (double)issueTimeNano / 1000000.0;
            this.panelsTimeMs = (double)panelsTimeNano / 1000000.0;
        }

        public double getFieldsTimeMs() {
            return this.fieldsTimeMs;
        }

        public double getIssueTimeMs() {
            return this.issueTimeMs;
        }

        public double getPanelsTimeMs() {
            return this.panelsTimeMs;
        }
    }
}

