/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.issueeditor.action;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.components.issueeditor.action.ActionUtils;
import com.atlassian.jira.components.issueeditor.action.BaseEditAction;
import com.atlassian.jira.components.issueeditor.action.DefaultContentIdCollector;
import com.atlassian.jira.components.issueeditor.action.EditFields;
import com.atlassian.jira.components.issueviewer.viewissue.IssueFieldProvider;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.rest.json.beans.FieldHtmlBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugins.rest.common.json.DefaultJaxbJsonMarshaller;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import webwork.action.Action;
import webwork.action.ActionContext;

public class AjaxIssueEditAction
extends BaseEditAction {
    private EditFields fields;

    public AjaxIssueEditAction(IssueService issueService, IssueFieldProvider issueFieldProvider) {
        super(issueService, issueFieldProvider);
    }

    public String doDefault() throws Exception {
        ActionContext.getResponse().setContentType("application/json");
        IssueService.IssueResult result = this.issueService.getIssue(this.getLoggedInUser(), this.issueId);
        MutableIssue issue = result.getIssue();
        if (!result.isValid() || result.getIssue() == null) {
            this.fields = new EditFields(Collections.emptyList(), this.getXsrfToken(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection()));
            AjaxIssueEditAction.setErrorReturnCode(result, this.getLoggedInUser());
            return this.JSON();
        }
        if (!this.issueService.isEditable((Issue)issue, this.getLoggedInUser())) {
            this.fields = new EditFields(Collections.emptyList(), this.getXsrfToken(), ErrorCollection.of((String[])new String[]{this.getText("editissue.error.no.edit.permission")}));
            ActionContext.getResponse().setStatus(401);
            return this.JSON();
        }
        DefaultContentIdCollector contentIdCollector = this.createContentIdCollector();
        List<FieldHtmlBean> editFields = this.issueFieldProvider.getEditFields(this.getLoggedInUser(), this, (Action)this, (Issue)issue, false, contentIdCollector);
        this.fields = new EditFields(editFields, this.getXsrfToken(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection()));
        return this.JSON();
    }

    private String JSON() throws IOException {
        ActionContext.getResponse().getWriter().append(this.getJson());
        return null;
    }

    private static void setErrorReturnCode(IssueService.IssueResult result, ApplicationUser user) {
        if (user == null || result.getErrorCollection().getReasons().contains(ErrorCollection.Reason.FORBIDDEN)) {
            ActionContext.getResponse().setStatus(401);
        } else {
            ActionUtils.setErrorReturnCode(user);
        }
    }

    public String getJson() {
        DefaultJaxbJsonMarshaller marshaller = new DefaultJaxbJsonMarshaller();
        return marshaller.marshal((Object)this.fields);
    }
}

