/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.remotejira.rest.resource;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.jira.plugin.link.applinks.RemoteResponse;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraRestService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@AnonymousAllowed
@Path(value="remoteJira")
public class RemoteJiraRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteJiraRestResource.class);
    private final ApplicationLinkService applicationLinkService;
    private final RemoteJiraRestService remoteJiraRestService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final I18nHelper.BeanFactory beanFactory;

    @Autowired
    public RemoteJiraRestResource(@ComponentImport ApplicationLinkService applicationLinkService, RemoteJiraRestService remoteJiraRestService, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport I18nHelper.BeanFactory beanFactory) {
        this.applicationLinkService = applicationLinkService;
        this.remoteJiraRestService = remoteJiraRestService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.beanFactory = beanFactory;
    }

    @GET
    @Path(value="/picker")
    @Produces(value={"application/json"})
    public Response getPicker(@QueryParam(value="appId") String appId, @QueryParam(value="query") String query, @QueryParam(value="currentJQL") String currentJQL, @QueryParam(value="currentIssueKey") String currentIssueKey, @QueryParam(value="currentProjectId") String currentProjectId, @QueryParam(value="showSubTasks") boolean showSubTasks, @QueryParam(value="showSubTaskParent") boolean showSubTaskParent) {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        if (query != null) {
            mapBuilder.put((Object)"query", (Object)query);
        }
        if (currentJQL != null) {
            mapBuilder.put((Object)"currentJQL", (Object)currentJQL);
        }
        if (currentIssueKey != null) {
            mapBuilder.put((Object)"currentIssueKey", (Object)currentIssueKey);
        }
        if (currentProjectId != null) {
            mapBuilder.put((Object)"currentProjectId", (Object)currentProjectId);
        }
        mapBuilder.put((Object)"showSubTasks", (Object)String.valueOf(showSubTasks));
        mapBuilder.put((Object)"showSubTaskParent", (Object)String.valueOf(showSubTaskParent));
        return this.invokeRestRequest(appId, "issues/picker", (Map<String, String>)mapBuilder.build(), RemoteJiraRestService.RestVersion.VERSION_1);
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response getSearch(@QueryParam(value="appId") String appId, @QueryParam(value="jql") String jql, @QueryParam(value="maxResults") Integer maxResults) {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        mapBuilder.put((Object)"jql", (Object)jql);
        if (maxResults != null) {
            mapBuilder.put((Object)"maxResults", (Object)maxResults.toString());
        }
        return this.invokeRestRequest(appId, "search", (Map<String, String>)mapBuilder.build(), RemoteJiraRestService.RestVersion.VERSION_2);
    }

    @GET
    @Path(value="/autocomplete")
    @Produces(value={"application/json"})
    public Response getSearchAutoComplete(@QueryParam(value="appId") String appId, @QueryParam(value="fieldName") String fieldName, @QueryParam(value="fieldValue") String fieldValue, @QueryParam(value="predicateName") String predicateName, @QueryParam(value="predicateValue") String predicateValue) {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        if (fieldName != null) {
            mapBuilder.put((Object)"fieldName", (Object)fieldName);
        }
        if (fieldValue != null) {
            mapBuilder.put((Object)"fieldValue", (Object)fieldValue);
        }
        if (predicateName != null) {
            mapBuilder.put((Object)"predicateName", (Object)predicateName);
        }
        if (predicateValue != null) {
            mapBuilder.put((Object)"predicateValue", (Object)predicateValue);
        }
        return this.invokeRestRequest(appId, "jql/autocompletedata/suggestions", (Map<String, String>)mapBuilder.build(), RemoteJiraRestService.RestVersion.VERSION_2);
    }

    @GET
    @Path(value="/autocompletedata")
    @Produces(value={"application/json"})
    public Response getSearchAutoCompleteData(@QueryParam(value="appId") String appId) {
        Map<String, String> params = Collections.emptyMap();
        return this.invokeRestRequest(appId, "jql/autocompletedata", params, RemoteJiraRestService.RestVersion.VERSION_2);
    }

    @GET
    @Path(value="/autocompletedata/legacy")
    @Produces(value={"application/json"})
    public Response getSearchAutoCompleteDataPre51(@QueryParam(value="appId") String appId) {
        ImmutableMap params = new ImmutableMap.Builder().put((Object)"navType", (Object)"advanced").build();
        return this.invokeURL(appId, "issues/", (Map<String, String>)params, new AutoCompleteDataLegacyConverter());
    }

    private Response invokeRestRequest(String appId, String resourcePath, Map<String, String> params, RemoteJiraRestService.RestVersion restVersion) {
        I18nHelper i18n = this.getI18n(this.jiraAuthenticationContext.getUser());
        ApplicationLink appLink = this.getJiraAppLink(appId);
        if (appLink == null) {
            ErrorCollection errors = ErrorCollection.of((String[])new String[]{i18n.getText("linkjiraissue.error.applink.not.found")});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).cacheControl(CacheControl.never()).build();
        }
        try {
            RemoteResponse<String> response = this.remoteJiraRestService.requestResource(appLink, resourcePath, params, restVersion);
            if (!response.isSuccessful()) {
                return this.handleUnsuccessfulResponse(response);
            }
            return Response.ok((Object)response.getEntity()).cacheControl(CacheControl.never()).build();
        }
        catch (CredentialsRequiredException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.never()).build();
        }
        catch (ResponseException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(CacheControl.never()).build();
        }
    }

    private Response invokeURL(String appId, String url, Map<String, String> params, ResponseConverter responseConverter) {
        I18nHelper i18n = this.getI18n(this.jiraAuthenticationContext.getUser());
        ApplicationLink appLink = this.getJiraAppLink(appId);
        if (appLink == null) {
            ErrorCollection errors = ErrorCollection.of((String[])new String[]{i18n.getText("linkjiraissue.error.applink.not.found")});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).cacheControl(CacheControl.never()).build();
        }
        try {
            RemoteResponse<String> response = this.remoteJiraRestService.requestURL(appLink, url, params);
            if (!response.isSuccessful()) {
                return this.handleUnsuccessfulResponse(response);
            }
            String entity = responseConverter == null ? (String)response.getEntity() : responseConverter.convert((String)response.getEntity());
            return Response.ok((Object)entity).cacheControl(CacheControl.never()).build();
        }
        catch (CredentialsRequiredException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.never()).build();
        }
        catch (ResponseException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(CacheControl.never()).build();
        }
    }

    private ApplicationLink getJiraAppLink(String appId) {
        for (ApplicationLink appLink : this.applicationLinkService.getApplicationLinks(JiraApplicationType.class)) {
            if (!appLink.getId().get().equals(appId)) continue;
            return appLink;
        }
        return null;
    }

    private Response handleUnsuccessfulResponse(RemoteResponse<?> response) {
        ErrorCollection errors = ErrorCollection.of((String[])new String[]{response.getStatusText()});
        if (response.hasErrors()) {
            errors.addErrorCollection(response.getErrors());
        }
        return Response.status((int)response.getStatusCode()).entity((Object)errors).cacheControl(CacheControl.never()).build();
    }

    private I18nHelper getI18n(ApplicationUser user) {
        return this.beanFactory.getInstance(user);
    }

    private static class AutoCompleteDataLegacyConverter
    implements ResponseConverter {
        private AutoCompleteDataLegacyConverter() {
        }

        @Override
        public String convert(String responseString) {
            int options = 42;
            Pattern fieldsPattern = Pattern.compile("<div[^>]*?jqlFieldz[^>]*?>(.*?)</div>", 42);
            Pattern functionsPattern = Pattern.compile("<div[^>]*?jqlFunctionNamez[^>]*?>(.*?)</div>", 42);
            Pattern reservedWordsPattern = Pattern.compile("<div[^>]*?jqlReservedWordz[^>]*?>(.*?)</div>", 42);
            return "{\"visibleFieldNames\": " + this.find(fieldsPattern, responseString) + ",\"visibleFunctionNames\": " + this.find(functionsPattern, responseString) + ",\"jqlReservedWords\": " + this.find(reservedWordsPattern, responseString) + "}";
        }

        private String find(Pattern p, String s) {
            Matcher m = p.matcher(s);
            if (m.find()) {
                return StringEscapeUtils.unescapeHtml((String)m.group(1));
            }
            return "[]";
        }
    }

    private static interface ResponseConverter {
        public String convert(String var1);
    }
}

