/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence.service.rpc;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.plugin.link.applinks.RemoteResponse;
import com.atlassian.jira.plugin.link.confluence.Builder;
import com.atlassian.jira.plugin.link.confluence.ConfluencePage;
import com.atlassian.jira.plugin.link.confluence.ConfluenceSearchResult;
import com.atlassian.jira.plugin.link.confluence.ConfluenceSpace;
import com.atlassian.jira.plugin.link.confluence.service.rpc.AbstractConfluenceSaxHandler;
import com.atlassian.jira.plugin.link.confluence.service.rpc.ConfluenceRpcService;
import com.atlassian.jira.plugin.link.confluence.service.rpc.PageResponseSaxHandler;
import com.atlassian.jira.plugin.link.confluence.service.rpc.SearchResponseSaxHandler;
import com.atlassian.jira.plugin.link.confluence.service.rpc.SpaceResponseSaxHandler;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;

@Component
@ExportAsService
public class ConfluenceRpcServiceImpl
implements ConfluenceRpcService {
    private static final String XMLRPC_URL = "rpc/xmlrpc";
    private static Set<String> SEARCH_TYPES = ImmutableSet.of((Object)"page", (Object)"blogpost");
    private static final String PAGE_XML_TEMPLATE = "<?xml version=\"1.0\"?><method><methodName>confluence2.getPage</methodName><params><param><value></value><value>%s</value></param></params></method >";
    private static final String BLOG_POST_XML_TEMPLATE = "<?xml version=\"1.0\"?><method><methodName>confluence2.getBlogEntry</methodName><params><param><value></value><value>%s</value></param></params></method >";
    private static final String SPACE_XML = "<?xml version=\"1.0\"?><method><methodName>confluence2.getSpaces</methodName><params><param><value></value></param></params></method >";
    private static final String SEARCH_XML_TEMPLATE = "<?xml version=\"1.0\"?><method><methodName>confluence2.search</methodName><params><param><value></value><value><string>%s</string></value><value><int>%d</int></value></param></params></method >";
    private static final String SEARCH_XML_TEMPLATE_WITH_SPACE_PARAM = "<?xml version=\"1.0\"?><method><methodName>confluence2.search</methodName><params><param><value></value><value><string>%s</string></value><value><struct><member><name>spaceKey</name><value><string>%s</string></value></member></struct></value><value><int>%d</int></value></param></params></method >";
    private static final Logger log = LoggerFactory.getLogger(ConfluenceRpcServiceImpl.class);

    @Override
    public RemoteResponse<ConfluencePage> getPage(ApplicationLink applicationLink, String pageId) throws CredentialsRequiredException, ResponseException {
        RemoteResponse<ConfluencePage> response = this.getGenericPage(applicationLink, pageId);
        boolean probablyNotAPage = this.checkIfResponseWasNotAPage(response);
        if (probablyNotAPage) {
            if (log.isDebugEnabled()) {
                log.debug("Remote link was not a page; will try as a blog post. Errors: {}", (Object)response.getErrors().getErrorMessages());
            }
            response = this.getBlogPost(applicationLink, pageId);
        }
        return response;
    }

    private boolean checkIfResponseWasNotAPage(RemoteResponse<ConfluencePage> response) {
        boolean hasClassCastEx = response.containsErrorWithText(new String[]{"ClassCastException"});
        boolean hasRemoteEx = response.containsErrorWithText(new String[]{"RemoteException"});
        boolean hadAuthProblem = hasRemoteEx && response.containsErrorWithText(new String[]{"not allowed to view"});
        boolean hadExistenceProblem = hasRemoteEx && response.containsErrorWithText(new String[]{"does not exist"});
        boolean probablyNotAPageInConf59x = hasRemoteEx && !hadAuthProblem && !hadExistenceProblem;
        return hasClassCastEx || probablyNotAPageInConf59x;
    }

    private RemoteResponse<ConfluencePage> getGenericPage(ApplicationLink applicationLink, String pageId) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequest request = ConfluenceRpcServiceImpl.createGetPageRequest(applicationLink, pageId);
        return (RemoteResponse)request.execute((ApplicationLinkResponseHandler)new PageResponseHandler());
    }

    private RemoteResponse<ConfluencePage> getBlogPost(ApplicationLink applicationLink, String pageId) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequest request = ConfluenceRpcServiceImpl.createGetBlogPostRequest(applicationLink, pageId);
        return (RemoteResponse)request.execute((ApplicationLinkResponseHandler)new PageResponseHandler());
    }

    @Override
    public RemoteResponse<List<ConfluenceSpace>> getSpaces(ApplicationLink applicationLink) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequest request = ConfluenceRpcServiceImpl.createGetSpacesRequest(applicationLink);
        return (RemoteResponse)request.execute((ApplicationLinkResponseHandler)new SpaceResponseHandler());
    }

    @Override
    public RemoteResponse<List<ConfluenceSearchResult>> search(ApplicationLink applicationLink, String query, int maxResults, @Nullable String spaceKey) throws CredentialsRequiredException, ResponseException {
        if (maxResults < 0) {
            throw new IllegalArgumentException("maxResults must be positive");
        }
        ApplicationLinkRequest request = ConfluenceRpcServiceImpl.createSearchRequest(applicationLink, query, maxResults * 2, spaceKey);
        return (RemoteResponse)request.execute((ApplicationLinkResponseHandler)new SearchResponseHandler(maxResults));
    }

    private static ApplicationLinkRequest createGetPageRequest(ApplicationLink applicationLink, String pageId) throws CredentialsRequiredException {
        String bodyXml = String.format(PAGE_XML_TEMPLATE, pageId);
        return ConfluenceRpcServiceImpl.createRequest(applicationLink, bodyXml);
    }

    private static ApplicationLinkRequest createGetBlogPostRequest(ApplicationLink applicationLink, String pageId) throws CredentialsRequiredException {
        String bodyXml = String.format(BLOG_POST_XML_TEMPLATE, pageId);
        return ConfluenceRpcServiceImpl.createRequest(applicationLink, bodyXml);
    }

    private static ApplicationLinkRequest createGetSpacesRequest(ApplicationLink applicationLink) throws CredentialsRequiredException {
        return ConfluenceRpcServiceImpl.createRequest(applicationLink, SPACE_XML);
    }

    private static ApplicationLinkRequest createSearchRequest(ApplicationLink applicationLink, String query, int maxResults, String spaceKey) throws CredentialsRequiredException {
        String bodyXml = spaceKey == null ? String.format(SEARCH_XML_TEMPLATE, query, maxResults) : String.format(SEARCH_XML_TEMPLATE_WITH_SPACE_PARAM, query, spaceKey, maxResults);
        return ConfluenceRpcServiceImpl.createRequest(applicationLink, bodyXml);
    }

    private static ApplicationLinkRequest createRequest(ApplicationLink applicationLink, String bodyXml) throws CredentialsRequiredException {
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.POST, XMLRPC_URL);
        request.setRequestBody(bodyXml, "application/xml");
        return request;
    }

    private static <T, B extends Builder<T>> RemoteResponse<List<T>> handleResponse(Response response, AbstractConfluenceSaxHandler<T, B> handler) throws ResponseException {
        String responseString = ConfluenceRpcServiceImpl.getResponseBodyAsString(response);
        List<T> entities = null;
        SimpleErrorCollection errors = null;
        if (response.isSuccessful() && !StringUtils.isBlank((String)responseString)) {
            entities = ConfluenceRpcServiceImpl.parseXml(responseString, handler);
            if (handler.hasFault()) {
                errors = new SimpleErrorCollection();
                errors.addErrorMessage(handler.getFaultString());
            }
        }
        return new RemoteResponse(entities, errors, response);
    }

    private static <T, B extends Builder<T>> List<T> parseXml(String responseString, AbstractConfluenceSaxHandler<T, B> handler) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            SAXParser saxParser = factory.newSAXParser();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(responseString.getBytes());
            saxParser.parse((InputStream)inputStream, handler);
            return handler.getEntities();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Failed to parse Confluence Remote API response", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Failed to parse Confluence Remote API response", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse Confluence Remote API response", e);
        }
    }

    private static String getResponseBodyAsString(Response response) throws ResponseException {
        InputStream responseBodyStream = response.getResponseBodyAsStream();
        String charset = ConfluenceRpcServiceImpl.getCharset(response);
        try {
            return IOUtil.toString((InputStream)responseBodyStream, (String)charset);
        }
        catch (IOException exception) {
            throw new ResponseException("Failed to read remote JIRA issue", (Throwable)exception);
        }
    }

    private static String getCharset(Response response) {
        ContentType contentType;
        String DEFAULT = "UTF-8";
        String contentTypeString = response.getHeader("Content-Type");
        if (contentTypeString == null) {
            return "UTF-8";
        }
        try {
            contentType = new ContentType(contentTypeString);
        }
        catch (ParseException exception) {
            return "UTF-8";
        }
        return StringUtils.defaultIfEmpty((String)contentType.getParameter("charset"), (String)"UTF-8");
    }

    private static class SearchResponseHandler
    implements ApplicationLinkResponseHandler<RemoteResponse<List<ConfluenceSearchResult>>> {
        private final int maxResults;

        private SearchResponseHandler(int maxResults) {
            this.maxResults = maxResults;
        }

        public RemoteResponse<List<ConfluenceSearchResult>> credentialsRequired(Response response) throws ResponseException {
            return RemoteResponse.credentialsRequired((Response)response);
        }

        public RemoteResponse<List<ConfluenceSearchResult>> handle(Response response) throws ResponseException {
            RemoteResponse handledResponse = ConfluenceRpcServiceImpl.handleResponse(response, new SearchResponseSaxHandler());
            List<ConfluenceSearchResult> searchResults = this.filterResults((List)handledResponse.getEntity());
            return new RemoteResponse(searchResults, response);
        }

        private List<ConfluenceSearchResult> filterResults(List<ConfluenceSearchResult> results) {
            Iterable iterable = Iterables.filter(results, (Predicate)new Predicate<ConfluenceSearchResult>(){

                public boolean apply(@Nullable ConfluenceSearchResult input) {
                    return SEARCH_TYPES.contains(input.getType());
                }
            });
            ArrayList filtered = Lists.newArrayList((Iterable)iterable);
            if (filtered.size() > this.maxResults) {
                return filtered.subList(0, this.maxResults);
            }
            return filtered;
        }
    }

    private static class SpaceResponseHandler
    implements ApplicationLinkResponseHandler<RemoteResponse<List<ConfluenceSpace>>> {
        private SpaceResponseHandler() {
        }

        public RemoteResponse<List<ConfluenceSpace>> credentialsRequired(Response response) throws ResponseException {
            return RemoteResponse.credentialsRequired((Response)response);
        }

        public RemoteResponse<List<ConfluenceSpace>> handle(Response response) throws ResponseException {
            return ConfluenceRpcServiceImpl.handleResponse(response, new SpaceResponseSaxHandler());
        }
    }

    private static class PageResponseHandler
    implements ApplicationLinkResponseHandler<RemoteResponse<ConfluencePage>> {
        private PageResponseHandler() {
        }

        public RemoteResponse<ConfluencePage> credentialsRequired(Response response) throws ResponseException {
            return RemoteResponse.credentialsRequired((Response)response);
        }

        public RemoteResponse<ConfluencePage> handle(Response response) throws ResponseException {
            RemoteResponse handledResponse = ConfluenceRpcServiceImpl.handleResponse(response, new PageResponseSaxHandler());
            List pages = (List)handledResponse.getEntity();
            ConfluencePage page = pages == null ? null : (ConfluencePage)Iterables.getOnlyElement((Iterable)pages, null);
            return new RemoteResponse((Object)page, handledResponse.getErrors(), response);
        }
    }
}

