/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence.service.rest;

import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.link.applinks.RemoteResponse;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfluenceRestResponseHandler<T>
implements ApplicationLinkResponseHandler<RemoteResponse<T>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractConfluenceRestResponseHandler.class);
    private String baseUrl = null;

    public RemoteResponse<T> credentialsRequired(Response response) throws ResponseException {
        return RemoteResponse.credentialsRequired((Response)response);
    }

    public RemoteResponse<T> handle(Response response) throws ResponseException {
        String body = response.getResponseBodyAsString();
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Object result = null;
        try {
            JSONObject responseObj = new JSONObject(body);
            this.baseUrl = this.getBaseUrl(responseObj);
            result = this.parseJsonResponse(responseObj, (ErrorCollection)errors);
        }
        catch (JSONException e) {
            log.debug("Encountered a JSON parsing problem for the Confluence REST API response...", (Throwable)e);
            errors.addErrorMessage(this.i18n("addconfluencelink.search.error", new Object[0]));
        }
        if (errors.hasAnyErrors()) {
            return new RemoteResponse(result, (ErrorCollection)errors, response);
        }
        return new RemoteResponse(result, response);
    }

    String i18n(String i18nKey, Object ... args) {
        I18nHelper i18n = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
        return i18n.getText(i18nKey, (Object)args);
    }

    protected String fullConfluenceUrl(JSONObject links) throws JSONException {
        return new UrlBuilder(this.baseUrl).addPathUnsafe(links.getString("webui")).asUrlString();
    }

    protected String getBaseUrl(JSONObject responseObj) throws JSONException {
        if (responseObj.has("_links")) {
            return responseObj.getJSONObject("_links").getString("base");
        }
        return null;
    }

    abstract T parseJsonResponse(JSONObject var1, ErrorCollection var2) throws JSONException;
}

