/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence.service.rest;

import com.atlassian.jira.plugin.link.confluence.service.rest.AbstractConfluenceRestResponseHandler;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfluenceRestCollectionResponseHandler<T>
extends AbstractConfluenceRestResponseHandler<List<T>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractConfluenceRestCollectionResponseHandler.class);
    private static final Map<Integer, String> errorsForStatuses = MapBuilder.newBuilder().add((Object)400, (Object)"searchconfluence.error.bad.request").add((Object)401, (Object)"searchconfluence.error.forbidden").add((Object)403, (Object)"searchconfluence.error.forbidden").add((Object)404, (Object)"searchconfluence.error.not.found").add((Object)500, (Object)"addconfluencelink.search.servererror").add((Object)503, (Object)"addconfluencelink.search.servererror").add((Object)0, (Object)"addconfluencelink.search.commserror").toHashMap();

    @Override
    List<T> parseJsonResponse(JSONObject responseObj, ErrorCollection errors) throws JSONException {
        Integer statusCode = responseObj.has("statusCode") ? responseObj.getInt("statusCode") : 200;
        String message = responseObj.has("message") ? responseObj.getString("message") : null;
        List<T> results = null;
        if (errorsForStatuses.containsKey(statusCode)) {
            errors.addErrorMessage(this.i18n(errorsForStatuses.get(statusCode), message));
        } else {
            if (StringUtils.isNotBlank((CharSequence)message)) {
                log.debug("Confluence REST API returned a non-empty message for a 'successful' response: ", (Object)message);
            } else {
                log.debug("Confluence REST API returned something we can use.");
            }
            results = this.processResults(responseObj, errors);
        }
        return results;
    }

    List<T> processResults(JSONObject responseObj, ErrorCollection errors) throws JSONException {
        Integer size;
        ArrayList results = Lists.newArrayList();
        Integer n = size = responseObj.has("size") ? Integer.valueOf(responseObj.getInt("size")) : null;
        if (size == null || size <= 0) {
            log.debug("Confluence returned zero results");
        } else {
            List<JSONObject> jsonSearchObjects = AbstractConfluenceRestCollectionResponseHandler.convertToList(responseObj.getJSONArray("results"));
            List confSearchObjects = jsonSearchObjects.stream().map(this::processResult).filter(Objects::nonNull).collect(Collectors.toList());
            int resultsInError = jsonSearchObjects.size() - confSearchObjects.size();
            if (resultsInError > 0) {
                errors.addErrorMessage(this.i18n("searchconfluence.error.partial.result.parsing", resultsInError));
            }
            results.addAll(confSearchObjects);
        }
        return results;
    }

    @VisibleForTesting
    abstract T processResult(JSONObject var1);

    static List<JSONObject> convertToList(@Nonnull JSONArray results) {
        ArrayList resultsList = Lists.newArrayList();
        for (int i = 0; i < results.length(); ++i) {
            resultsList.add(results.optJSONObject(i));
        }
        return resultsList;
    }
}

