/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence.service;

import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.link.confluence.service.ConfluenceRemoteService;
import com.atlassian.jira.plugin.link.confluence.service.rest.ConfluenceRestService;
import com.atlassian.jira.plugin.link.confluence.service.rpc.ConfluenceRpcService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceRemoteServiceStrategyFactory
implements Supplier<ConfluenceRemoteService> {
    private static final String FEATURE_FLAG_KEY = "confluence.issuelinks.use.rest.api";
    @VisibleForTesting
    static final FeatureFlag FEATURE_FLAG = FeatureFlag.featureFlag((String)"confluence.issuelinks.use.rest.api").defaultedTo(true);
    private final FeatureManager featureManager;
    private final ConfluenceRestService restService;
    private final ConfluenceRpcService rpcService;

    @Autowired
    public ConfluenceRemoteServiceStrategyFactory(ConfluenceRestService restService, ConfluenceRpcService rpcService, @ComponentImport FeatureManager featureManager) {
        this.featureManager = featureManager;
        this.restService = restService;
        this.rpcService = rpcService;
    }

    @Override
    public ConfluenceRemoteService get() {
        if (this.shouldUseREST()) {
            return this.getRestService();
        }
        return this.getRpcService();
    }

    private boolean shouldUseREST() {
        return this.featureManager.isEnabled(FEATURE_FLAG);
    }

    private ConfluenceRestService getRestService() {
        return this.restService;
    }

    private ConfluenceRpcService getRpcService() {
        return this.rpcService;
    }
}

