/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence.service;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.plugin.link.applinks.RemoteResponse;
import com.atlassian.jira.plugin.link.confluence.service.ConfluencePageService;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfluencePageServiceImpl
implements ConfluencePageService {
    @Override
    public RemoteResponse<String> getPageId(ApplicationLink applicationLink, String pageUrl) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        int hash = pageUrl.indexOf(35);
        if (hash >= 0) {
            pageUrl = pageUrl.substring(0, hash);
        }
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, pageUrl);
        request.setFollowRedirects(false);
        return (RemoteResponse)request.execute((ApplicationLinkResponseHandler)new PageResponseHandler(requestFactory));
    }

    private static String getResponseBodyAsString(Response response) throws ResponseException {
        InputStream responseBodyStream = response.getResponseBodyAsStream();
        String charset = ConfluencePageServiceImpl.getCharset(response);
        try {
            return IOUtil.toString((InputStream)responseBodyStream, (String)charset);
        }
        catch (IOException exception) {
            throw new ResponseException("Failed to read remote JIRA issue", (Throwable)exception);
        }
    }

    private static String getCharset(Response response) {
        ContentType contentType;
        String DEFAULT = "UTF-8";
        String contentTypeString = response.getHeader("Content-Type");
        if (contentTypeString == null) {
            return "UTF-8";
        }
        try {
            contentType = new ContentType(contentTypeString);
        }
        catch (ParseException exception) {
            return "UTF-8";
        }
        return StringUtils.defaultIfEmpty((String)contentType.getParameter("charset"), (String)"UTF-8");
    }

    private static class PageResponseHandler
    implements ApplicationLinkResponseHandler<RemoteResponse<String>> {
        private static final int MAX_REDIRECTS = 3;
        private static final Logger LOG = LoggerFactory.getLogger(PageResponseHandler.class);
        private static final Pattern JSESSIONID_PATTERN = Pattern.compile("(.*);jsessionid=\\w+(.*)");
        private final ApplicationLinkRequestFactory requestFactory;
        private int redirectCount = 0;

        public PageResponseHandler(ApplicationLinkRequestFactory requestFactory) {
            this.requestFactory = requestFactory;
        }

        public RemoteResponse<String> credentialsRequired(Response response) throws ResponseException {
            return RemoteResponse.credentialsRequired((Response)response);
        }

        public RemoteResponse<String> handle(Response response) throws ResponseException {
            if (response.getStatusCode() >= 300 && response.getStatusCode() < 400) {
                ++this.redirectCount;
                String location = this.stripJsessionid(response.getHeader("location"));
                if (StringUtils.isNotBlank((String)location)) {
                    if (this.redirectCount <= 3) {
                        try {
                            ApplicationLinkRequest request = this.requestFactory.createRequest(Request.MethodType.GET, location);
                            request.setFollowRedirects(false);
                            return (RemoteResponse)request.execute((ApplicationLinkResponseHandler)this);
                        }
                        catch (CredentialsRequiredException e) {
                            return RemoteResponse.credentialsRequired((Response)response);
                        }
                    }
                    LOG.warn("Maximum of 3 redirects reached. Not following redirect to '" + location + "' , returning response instead.");
                } else {
                    LOG.warn("HTTP response returned redirect code " + response.getStatusCode() + " but did not provide a location header or the location header did not contain a value");
                }
            }
            String responseString = ConfluencePageServiceImpl.getResponseBodyAsString(response);
            String pageId = null;
            if (!StringUtils.isBlank((String)responseString)) {
                pageId = this.parsePageSource(responseString);
            }
            return new RemoteResponse((Object)pageId, response);
        }

        private String stripJsessionid(String url) {
            Matcher matcher = JSESSIONID_PATTERN.matcher(url);
            if (matcher.matches()) {
                return matcher.group(1) + matcher.group(2);
            }
            return url;
        }

        private String parsePageSource(String responseString) {
            Pattern p = Pattern.compile("<meta name=\"ajs-page-id\" content=\"(\\d+)\">");
            Matcher m = p.matcher(responseString);
            if (m.find()) {
                return m.group(1);
            }
            return null;
        }
    }
}

