/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.applinks;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.sal.api.net.Response;
import javax.annotation.Nullable;

public class RemoteResponse<T> {
    private final T entity;
    private final ErrorCollection errors;
    private final int statusCode;
    private final String statusText;
    private final boolean successful;

    public RemoteResponse(@Nullable T entity, @Nullable ErrorCollection errors, Response response) {
        this.entity = entity;
        this.errors = errors;
        this.statusCode = response.getStatusCode();
        this.statusText = response.getStatusText();
        this.successful = response.isSuccessful();
    }

    public RemoteResponse(@Nullable T entity, Response response) {
        this(entity, null, response);
    }

    public T getEntity() {
        return this.entity;
    }

    public boolean hasErrors() {
        return this.errors != null && this.errors.hasAnyErrors();
    }

    public ErrorCollection getErrors() {
        return this.errors;
    }

    public boolean containsErrorWithText(String ... text) {
        if (this.hasErrors()) {
            for (String errorMessage : this.errors.getErrorMessages()) {
                if (!RemoteResponse.messageContainsText(errorMessage, text)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean messageContainsText(String message, String ... text) {
        for (String snippet : text) {
            if (message.contains(snippet)) continue;
            return false;
        }
        return true;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public boolean isSuccessful() {
        return this.successful && !this.hasErrors();
    }

    public static <E> RemoteResponse<E> credentialsRequired(Response response) {
        return new RemoteResponse<Object>(null, response);
    }
}

