/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.applinks;

import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.jira.plugin.link.applinks.AppLinkUtils;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.google.common.collect.Iterables;
import java.util.Map;

public class HasApplicationLinkCondition
implements Condition {
    private final ApplicationLinkService applicationLinkService;
    private Class<ApplicationType> applicationTypeClass;

    public HasApplicationLinkCondition(@ComponentImport ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String applicationType = params.get("applicationType");
        if (applicationType == null) {
            throw new PluginParseException("Parameter 'applicationType' must be defined for this condition");
        }
        try {
            this.applicationTypeClass = AppLinkUtils.getApplicationTypeClass(applicationType);
        }
        catch (IllegalArgumentException e) {
            throw new PluginParseException((Throwable)e);
        }
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return !Iterables.isEmpty((Iterable)this.applicationLinkService.getApplicationLinks(this.applicationTypeClass));
    }
}

