AJS.$(function() {

    var ajaxOperation = function(method, url, confirmTxt) {
        var answer = true;
        if(confirmTxt) {
            answer = confirm(confirmTxt);
        }
        if(answer) {
            AJS.$.ajax({
                type: method,
                url: url,
                success: function() {
                    window.location.reload();
                },
                error:function(response) {
                    var msgContainer = AJS.$(".ajax-msg-container");
                    AJS.messages.error(msgContainer, {
                        title:AJS.I18n.getText("collector.plugin.template.ajaxerror"),
                        body: "<p>" + AJS.I18n.getText("collector.plugin.template.ajaxerror.msg") + "</p>",
                        closeable: true
                    });
                }
            });
        }
    };

    AJS.$(".disable-collector-lnk").click(function(e) {
        e.preventDefault();
        ajaxOperation("delete", AJS.$(this).attr("href"));
    });

    AJS.$(".enable-collector-lnk").click(function(e) {
        e.preventDefault();
        ajaxOperation("post", AJS.$(this).attr("href"));
    });

    AJS.$(".delete-collector-lnk").click(function(e) {
        e.preventDefault();
        ajaxOperation("delete", AJS.$(this).attr("href"), AJS.I18n.getText("collector.plugin.admin.collector.delete.confirm"));
    });

    AJS.$(".clear-errors-lnk").click(function(e) {
        e.preventDefault();
        ajaxOperation("delete", AJS.$(this).attr("href"));
    });

	AJS.$("a.jic-operations-trigger").each(function() {
		var trigger = AJS.$(this);
		var content = trigger.siblings("div.jic-operations-list");
		new AJS.Dropdown({
			trigger: trigger,
			content: content
		});
	});

    AJS.$(".activitysparkline").sparkline('html', {lineWidth:1, spotRadius:0});

    AJS.$(".url-to-copy").focus(function(){
        this.select();
    }).mouseup(function(e) {
                e.preventDefault();
            });
});