AJS.test.require("com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:form-collector", function () {
    "use strict";

    require([
        "jquery"
    ], function(
        $
    ){
        module("PostMessageTests", {
            teardown: function() {
                $(window).unbind("message");
            }
        });

        asyncTest("Child iframe calls postMessage on parent 2 times when message is of type 'collector.iframe.loaded'", function(assert) {
            // we should get 3 callbacks. 1 for our manual post, and 2 from within collector.js (hasLoaded and height).
            expect(3);

            var message = {
                "messageType": "collector.iframe.loaded",
                "feedbackString": "",
                "fieldValues": ""
            };

            var callbackCounter = 0;
            $(window).bind("message", function() {
                if (callbackCounter == 0) {
                    start();
                }
                assert.ok(true, "Responded to postMessage " + (++callbackCounter));
            });

            // manually post a message to the window
            window.postMessage(JSON.stringify(message), '*');
        });

        asyncTest("Child iframe does not call postMessage on parent at all when message is not of type 'collector.iframe.loaded'", function(assert) {
            // we should only get a single callback hit. The 1 from our manual post.
            expect(1);

            var message = {
                "messageType": "some.other.event",
                "feedbackString": "",
                "fieldValues": ""
            };

            $(window).bind("message", function() {
                start();
                assert.ok(true, "Responded to postMessage");
            });

            // manually post a message to the window
            window.postMessage(JSON.stringify(message), '*');
        });
    });
});