/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsDevService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.export.ModuleType;
import com.atlassian.plugin.spring.scanner.extension.ExportedSeviceManager;
import com.atlassian.plugin.spring.scanner.util.AnnotationIndexReader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;

public class ServiceExporterBeanPostProcessor
implements DestructionAwareBeanPostProcessor,
InitializingBean {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String OSGI_SERVICE_SUFFIX = "_osgiService";
    private static final boolean isDevMode = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode", "false"));
    private final BundleContext bundleContext;
    private ConfigurableListableBeanFactory beanFactory;
    private String profileName;
    private final ExportedSeviceManager serviceManager;
    private ImmutableMap<String, String[]> exports;

    public ServiceExporterBeanPostProcessor(BundleContext bundleContext, ConfigurableListableBeanFactory beanFactory) {
        this.bundleContext = bundleContext;
        this.beanFactory = beanFactory;
        this.profileName = null;
        this.serviceManager = new ExportedSeviceManager();
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public void afterPropertiesSet() throws Exception {
        ImmutableMap.Builder<String, String[]> exportBuilder = ImmutableMap.builder();
        String[] profileNames = AnnotationIndexReader.splitProfiles(this.profileName);
        this.parseExportsForExportFile(exportBuilder, "exports", profileNames);
        if (isDevMode) {
            this.parseExportsForExportFile(exportBuilder, "dev-exports", profileNames);
        }
        this.exports = exportBuilder.build();
    }

    private void parseExportsForExportFile(ImmutableMap.Builder<String, String[]> exportBuilder, String exportFileName, String[] profileNames) {
        String[] defaultInterfaces = new String[]{};
        for (String fileToRead : AnnotationIndexReader.getIndexFilesForProfiles(profileNames, exportFileName)) {
            List<String> exportData = AnnotationIndexReader.readAllIndexFilesForProduct(fileToRead, this.bundleContext.getBundle());
            for (String export : exportData) {
                String[] targetAndInterfaces = StringUtils.split((String)export, (char)'#');
                String target = targetAndInterfaces[0];
                String[] interfaces = targetAndInterfaces.length > 1 ? StringUtils.split((String)targetAndInterfaces[1], (char)',') : defaultInterfaces;
                exportBuilder.put(target, interfaces);
            }
        }
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.serviceManager.hasService(bean)) {
            Object serviceBean;
            this.serviceManager.unregisterService(this.bundleContext, bean);
            String serviceName = this.getServiceName(beanName);
            if (this.beanFactory.containsBean(serviceName) && null != (serviceBean = this.beanFactory.getBean(serviceName))) {
                this.beanFactory.destroyBean(serviceName, serviceBean);
            }
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class[] interfaces = new Class[]{};
        String beanClassName = bean.getClass().getName();
        if (this.exports.containsKey(beanClassName) || this.isPublicComponent(bean)) {
            if (this.exports.containsKey(beanClassName)) {
                String[] interfaceNames;
                ImmutableList.Builder interfaceBuilder = ImmutableList.builder();
                ClassLoader beanClassLoader = bean.getClass().getClassLoader();
                for (String interfaceName : interfaceNames = this.exports.get(beanClassName)) {
                    try {
                        Class<?> interfaceClass = beanClassLoader.loadClass(interfaceName);
                        interfaceBuilder.add(interfaceClass);
                    }
                    catch (ClassNotFoundException ecnf) {
                        this.log.warn("Cannot find class for export '" + interfaceName + "' of bean '" + beanName + "': " + ecnf);
                    }
                }
                interfaces = Iterables.toArray(interfaceBuilder.build(), Class.class);
            } else if (this.hasAnnotation(bean, ModuleType.class)) {
                interfaces = bean.getClass().getAnnotation(ModuleType.class).value();
            } else if (this.hasAnnotation(bean, ExportAsService.class)) {
                interfaces = bean.getClass().getAnnotation(ExportAsService.class).value();
            } else if (this.hasAnnotation(bean, ExportAsDevService.class)) {
                interfaces = bean.getClass().getAnnotation(ExportAsDevService.class).value();
            }
            if (interfaces.length < 1 && (interfaces = bean.getClass().getInterfaces()).length < 1) {
                interfaces = new Class[]{bean.getClass()};
            }
            try {
                ServiceRegistration serviceRegistration = this.serviceManager.registerService(this.bundleContext, bean, beanName, new Hashtable<String, Object>(), interfaces);
                String serviceName = this.getServiceName(beanName);
                this.beanFactory.initializeBean((Object)serviceRegistration, serviceName);
            }
            catch (Exception e) {
                this.log.error("Unable to register bean '" + beanName + "' as an OSGi exported service", e);
            }
        }
        return bean;
    }

    private boolean isPublicComponent(Object bean) {
        return this.hasAnnotation(bean, ModuleType.class) || this.hasAnnotation(bean, ExportAsService.class) || this.hasAnnotation(bean, ExportAsDevService.class) && isDevMode;
    }

    private boolean hasAnnotation(Object bean, Class<? extends Annotation> annotationClass) {
        return bean.getClass().isAnnotationPresent(annotationClass);
    }

    private String getServiceName(String beanName) {
        return beanName + OSGI_SERVICE_SUFFIX;
    }
}

