/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.web.admin;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.CollectorActivityHelper;
import com.atlassian.jira.collector.plugin.components.CollectorService;
import com.atlassian.jira.collector.plugin.components.ErrorLog;
import com.atlassian.jira.collector.plugin.components.fieldchecker.MissingFieldsChecker;
import com.atlassian.jira.collector.plugin.web.admin.AbstractProjectAdminAction;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.seraph.util.RedirectUtils;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ViewCollectors
extends AbstractProjectAdminAction {
    private final CollectorService collectorService;
    private final ConstantsManager constantsManager;
    private final UserFormats userFormats;
    private final CollectorActivityHelper collectorActivityHelper;
    private final ErrorLog errorLog;
    private final MissingFieldsChecker missingFieldsChecker;
    private List<Collector> collectors;
    private Map<String, List<Integer>> collectorActivty = new HashMap<String, List<Integer>>();
    private List<Collector> collectorsWithMissingFields;
    private String updatedCollectorId;
    private Collector updatedCollector;
    private Boolean triggerChanged;

    public ViewCollectors(CollectorService collectorService, ConstantsManager constantsManager, UserFormats userFormats, CollectorActivityHelper collectorActivityHelper, ErrorLog errorLog, MissingFieldsChecker missingFieldsChecker) {
        this.collectorService = collectorService;
        this.constantsManager = constantsManager;
        this.userFormats = userFormats;
        this.collectorActivityHelper = collectorActivityHelper;
        this.errorLog = errorLog;
        this.missingFieldsChecker = missingFieldsChecker;
    }

    public String doDefault() throws Exception {
        if (this.getLoggedInUser() == null) {
            HttpServletRequest request = ExecutingHttpRequest.get();
            return this.forceRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)request));
        }
        if (this.getProject() == null) {
            this.addErrorMessageByKeyIfAbsent("collector.plugin.admin.error.no.project");
            return "error";
        }
        ServiceOutcome<List<Collector>> result = this.collectorService.getCollectors(this.getLoggedInUser(), this.getProject());
        if (!result.isValid()) {
            this.getErrorMessages().addAll(result.getErrorCollection().getErrorMessages());
            this.getErrors().putAll(result.getErrorCollection().getErrors());
            return "error";
        }
        this.collectors = (List)result.getReturnedValue();
        this.updatedCollector = (Collector)this.collectorService.getCollector(this.updatedCollectorId).getReturnedValue();
        this.collectorsWithMissingFields = this.missingFieldsChecker.getMisconfiguredCollectors(this.collectors, this.getProject());
        return "success";
    }

    public List<Collector> getCollectors() {
        return this.collectors;
    }

    public IssueType getIssueType(Long issueTypeId) {
        return this.constantsManager.getIssueTypeObject(issueTypeId.toString());
    }

    @HtmlSafe
    public String getFormattedUserAsHtml(String username, String className) {
        return this.userFormats.forType("profileLinkActionHeader").format(username, className);
    }

    public List<Integer> getActivityForCollector(Collector collector) {
        if (!this.collectorActivty.containsKey(collector.getId())) {
            this.collectorActivty.put(collector.getId(), this.collectorActivityHelper.getIssuesCreatedPerDay(this.getLoggedInUser(), collector, 30));
        }
        return this.collectorActivty.get(collector.getId());
    }

    public int getTotalNumberOfIssuesForCollector(Collector collector) {
        List<Integer> activityForCollector = this.getActivityForCollector(collector);
        int sum = 0;
        for (Integer issuesCreated : activityForCollector) {
            sum += issuesCreated.intValue();
        }
        return sum;
    }

    public String getActivityUrl(Collector collector) {
        return this.collectorActivityHelper.getIssueNavigatorUrl(this.getLoggedInUser(), collector);
    }

    public List<String> getCollectorErrors() {
        return this.errorLog.getFormattedErrors(this.getProject(), this.getLoggedInUser());
    }

    public List<Collector> getCollectorsWithMissingFields() {
        return this.collectorsWithMissingFields;
    }

    public Collector getUpdatedCollector() {
        return this.updatedCollector;
    }

    public Boolean getTriggerChanged() {
        return this.triggerChanged;
    }

    public void setTriggerChanged(Boolean triggerChanged) {
        this.triggerChanged = triggerChanged;
    }

    public void setUpdatedCollectorId(String updatedCollectorId) {
        this.updatedCollectorId = updatedCollectorId;
    }
}

