/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.web.admin;

import com.atlassian.jira.collector.plugin.components.CollectorFieldValidator;
import com.atlassian.jira.collector.plugin.rest.model.Field;
import com.atlassian.jira.collector.plugin.rest.model.Fields;
import com.atlassian.jira.collector.plugin.web.admin.AbstractProjectAdminAction;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugins.rest.common.json.DefaultJaxbJsonMarshaller;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.Action;
import webwork.action.ActionContext;

public class CreateFields
extends AbstractProjectAdminAction
implements OperationContext {
    private static final Map<String, Object> DISPLAY_PARAMS = MapBuilder.newBuilder((Object)"noHeader", (Object)"true", (Object)"theme", (Object)"aui", (Object)"isFirstField", (Object)true, (Object)"isLastField", (Object)true).toMutableMap();
    private static final Logger log = Logger.getLogger(CreateFields.class);
    public static final int TRIMED_NAME_LENGTH = 19;
    private Fields fields;
    private ErrorCollection errors;
    private String issueType;
    private final Map<String, Object> fieldValuesHolder = new HashMap<String, Object>();
    private final ConstantsManager constantsManager;
    private final IssueFactory issueFactory;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final ApplicationProperties applicationProperties;
    private final CollectorFieldValidator collectorFieldValidator;

    public CreateFields(ConstantsManager constantsManager, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, ApplicationProperties applicationProperties, CollectorFieldValidator collectorFieldValidator) {
        this.constantsManager = constantsManager;
        this.issueFactory = issueFactory;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.applicationProperties = applicationProperties;
        this.collectorFieldValidator = collectorFieldValidator;
    }

    public String doDefault() throws Exception {
        ActionContext.getResponse().setContentType("application/json");
        this.fields = new Fields();
        Project project = this.getProject();
        IssueType issueTypeObject = this.constantsManager.getIssueTypeObject(this.issueType);
        if (project == null || issueTypeObject == null) {
            this.errors = ErrorCollection.of((String[])new String[]{"No valid project or issue type provided"});
            ActionContext.getResponse().getWriter().print(this.getErrorJson());
            log.error((Object)String.format("No valid project or issue type provided; projectKey='%s', issueType='%s'", this.getProjectKey(), this.issueType));
            return null;
        }
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectId(project.getId());
        issue.setIssueTypeId(this.issueType);
        FieldScreenRenderer fieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(this.getLoggedInUser(), (Issue)issue, (IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION, false);
        List fieldScreenRenderTabs = fieldScreenRenderer.getFieldScreenRenderTabs();
        Set<String> allowedCustomFieldIds = this.collectorFieldValidator.getAllowedCustomFieldIds(project, this.issueType);
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderTabs) {
            for (FieldScreenRenderLayoutItem fsrli : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                OrderableField orderableField = fsrli.getOrderableField();
                if (!this.collectorFieldValidator.isFieldAllowedInCustomCollector(orderableField.getId()) && !allowedCustomFieldIds.contains(orderableField.getId())) continue;
                orderableField.populateDefaults(this.getFieldValuesHolder(), (Issue)issue);
                String createHtml = fsrli.getCreateHtml((Action)this, (OperationContext)this, (Issue)issue, DISPLAY_PARAMS);
                this.fields.addField(new Field(orderableField.getId(), this.getText(this.truncateFieldName(orderableField.getName())), this.isRequired(fsrli, (Issue)issue), StringUtils.trim((String)createHtml)));
            }
        }
        if (this.applicationProperties.getOption("jira.option.allowattachments")) {
            this.fields.addField(this.createSpecialAttachmentsField());
        }
        ActionContext.getResponse().getWriter().print(this.getJson());
        return null;
    }

    private boolean isRequired(FieldScreenRenderLayoutItem fsrli, Issue issue) {
        boolean hasDefaultValue = true;
        Object defaultValue = fsrli.getOrderableField().getDefaultValue(issue);
        if (defaultValue == null || defaultValue instanceof Collection && ((Collection)defaultValue).size() == 0) {
            hasDefaultValue = false;
        }
        if (fsrli.getOrderableField().getId().equals("assignee")) {
            return false;
        }
        return fsrli.isRequired() && !hasDefaultValue;
    }

    private Field createSpecialAttachmentsField() {
        String editHtml = String.format("<fieldset class=\"group\">\n     <legend><span>%s</span></legend>\n     <div id=\"screenshot-group\" class=\"field-group\">\n         <input type=\"file\" name=\"screenshot\" class=\"file\" id=\"screenshot\">\n     </div>\n</fieldset>\n", this.getText("collector.plugin.template.add.file"));
        return new Field("screenshots", this.getText("collector.plugin.template.add.file"), false, editHtml);
    }

    private String truncateFieldName(String name) {
        if (name.length() > 19) {
            StringBuilder sb = new StringBuilder(30);
            sb.append(name.substring(0, 19)).append("...");
            return sb.toString();
        }
        return name;
    }

    @HtmlSafe
    public String getJson() {
        DefaultJaxbJsonMarshaller marshaller = new DefaultJaxbJsonMarshaller();
        return marshaller.marshal((Object)this.fields);
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    @HtmlSafe
    public String getErrorJson() {
        DefaultJaxbJsonMarshaller marshaller = new DefaultJaxbJsonMarshaller();
        return marshaller.marshal((Object)this.errors);
    }

    public Map getFieldValuesHolder() {
        return this.fieldValuesHolder;
    }

    public IssueOperation getIssueOperation() {
        return IssueOperations.CREATE_ISSUE_OPERATION;
    }
}

