/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.web.admin;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.CollectorFieldValidator;
import com.atlassian.jira.collector.plugin.components.CollectorService;
import com.atlassian.jira.collector.plugin.components.Template;
import com.atlassian.jira.collector.plugin.components.TemplateStore;
import com.atlassian.jira.collector.plugin.components.Trigger;
import com.atlassian.jira.collector.plugin.components.fieldchecker.MissingFieldsChecker;
import com.atlassian.jira.collector.plugin.web.admin.AbstractProjectAdminAction;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.OperationContextImpl;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.seraph.util.RedirectUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import webwork.action.Action;
import webwork.action.ActionContext;

public class AddCollector
extends AbstractProjectAdminAction {
    private final CollectorService collectorService;
    private final UserPickerSearchService searchService;
    private final TemplateStore templateStore;
    private final PermissionManager permissionManager;
    private final IssueFactory issueFactory;
    private final MissingFieldsChecker missingFieldsChecker;
    private final CollectorFieldValidator collectorFieldValidator;
    private final FieldManager fieldManager;
    private final FieldLayoutManager fieldLayoutManager;
    private static final String NO_ADD_PERMISSION = "noaddpermission";
    private static final String UPDATED = "updated";
    private Long issuetype;
    private String name;
    private String reporter;
    private String description;
    private String templateId;
    private boolean recordWebInfo;
    private boolean useCredentials;
    private String triggerText;
    private String triggerPosition;
    private String customFunction;
    private String customMessage;
    private String customTemplateFields;
    private String customTemplateTitle;
    private String customTemplateLabels;
    private String collectorId;
    private boolean editMode;

    public AddCollector(CollectorService collectorService, UserPickerSearchService searchService, TemplateStore templateStore, PermissionManager permissionManager, IssueFactory issueFactory, MissingFieldsChecker missingFieldsChecker, CollectorFieldValidator collectorFieldValidator, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager) {
        this.collectorService = collectorService;
        this.searchService = searchService;
        this.templateStore = templateStore;
        this.permissionManager = permissionManager;
        this.issueFactory = issueFactory;
        this.missingFieldsChecker = missingFieldsChecker;
        this.collectorFieldValidator = collectorFieldValidator;
        this.fieldManager = fieldManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    @Nullable
    private String validateCommandParams() {
        if (this.getLoggedInUser() == null) {
            HttpServletRequest request = ExecutingHttpRequest.get();
            return this.forceRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)request));
        }
        if (this.getPid() == null) {
            this.addErrorMessageByKeyIfAbsent("collector.plugin.admin.error.no.project");
            return "error";
        }
        ServiceOutcome<Boolean> outcome = this.collectorService.validateCreateCollector(this.getProject(), this.getLoggedInUser());
        if (!((Boolean)outcome.getReturnedValue()).booleanValue()) {
            this.addErrorCollection(outcome.getErrorCollection());
            return NO_ADD_PERMISSION;
        }
        return null;
    }

    public String doDefault() throws Exception {
        String invalidAction = this.validateCommandParams();
        if (invalidAction != null) {
            return invalidAction;
        }
        this.useCredentials = false;
        this.triggerPosition = Trigger.Position.TOP.toString();
        this.triggerText = this.getText("collector.plugin.trigger.text.default");
        this.recordWebInfo = true;
        this.useCredentials = false;
        this.templateId = this.templateStore.getTemplates().get(0).getId();
        this.customTemplateFields = new JSONArray(Lists.newArrayList()).toString();
        this.customTemplateTitle = "";
        this.customMessage = this.getText("collector.plugin.admin.custom.message");
        return "input";
    }

    public String doEdit() {
        String result = this.copyExistingCollectorParameters();
        if (result != null) {
            return result;
        }
        this.editMode = true;
        return "input";
    }

    public String doCopy() {
        String result = this.copyExistingCollectorParameters();
        if (result != null) {
            return result;
        }
        this.collectorId = null;
        this.name = this.getText("common.words.copyof", this.name);
        return "input";
    }

    @Nullable
    private String copyExistingCollectorParameters() {
        Collector collector;
        String invalidAction = this.validateCommandParams();
        if (invalidAction != null) {
            return invalidAction;
        }
        Collector collector2 = collector = this.collectorId == null ? null : (Collector)this.collectorService.getCollector(this.collectorId).getReturnedValue();
        if (collector == null) {
            this.addErrorMessageIfAbsent(this.getText("collector.plugin.admin.error.no.template", this.collectorId));
            return "error";
        }
        if (!this.collectorService.hasViewPermission(this.getLoggedInUser(), collector)) {
            this.addErrorMessageByKeyIfAbsent("collector.plugin.admin.error.view.no.permission");
            return "error";
        }
        this.name = collector.getName();
        this.description = collector.getDescription();
        this.issuetype = collector.getIssueTypeId();
        this.reporter = collector.getReporter();
        this.triggerPosition = collector.getTrigger().getPosition().toString();
        this.triggerText = collector.getTrigger().getText();
        this.recordWebInfo = collector.isRecordWebInfo();
        this.useCredentials = collector.isUseCredentials();
        this.templateId = collector.getTemplate().getId();
        this.customFunction = collector.getTrigger().getCustomFunction();
        this.customMessage = collector.getCustomMessage();
        this.customTemplateTitle = collector.getCustomTemplateTitle();
        this.customTemplateFields = new JSONArray(collector.getCustomTemplateFields()).toString();
        this.customTemplateLabels = collector.getCustomTemplateLabels();
        return null;
    }

    protected void doValidation() {
        this.updateCheckboxes();
        Trigger trigger = new Trigger(this.triggerText, Trigger.Position.valueOf(this.triggerPosition), this.customFunction);
        ServiceOutcome<Collector> outcome = this.collectorService.validateCreateCollector(this.getLoggedInUser(), this.name, this.getPid(), this.issuetype, this.reporter, this.description, this.templateId, this.recordWebInfo, this.useCredentials, trigger, this.customMessage, this.getCustomTemplateFieldList(), this.customTemplateTitle, this.customTemplateLabels);
        if (!outcome.isValid()) {
            this.addErrorCollection(outcome.getErrorCollection());
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Long projectId;
        this.updateCheckboxes();
        if (StringUtils.isNotBlank((String)this.collectorId)) {
            ServiceOutcome<Collector> outcome = this.collectorService.getCollector(this.collectorId);
            Collector existingCollector = (Collector)outcome.getReturnedValue();
            if (!outcome.isValid() || existingCollector == null) {
                this.addErrorMessage("Invalid collector id " + this.collectorId);
                return "error";
            }
            projectId = existingCollector.getProjectId();
        } else {
            projectId = this.getPid();
        }
        Trigger trigger = new Trigger(this.triggerText, Trigger.Position.valueOf(this.triggerPosition), this.customFunction);
        ServiceOutcome<Collector> collectorData = this.collectorService.validateCreateCollector(this.getLoggedInUser(), this.name, projectId, this.issuetype, this.reporter, this.description, this.templateId, this.recordWebInfo, this.useCredentials, trigger, this.customMessage, this.getCustomTemplateFieldList(), this.customTemplateTitle, this.customTemplateLabels);
        if (collectorData.isValid()) {
            if (StringUtils.isBlank((String)this.collectorId)) {
                String createdCollectorId = this.collectorService.createCollector(collectorData);
                return this.getRedirect("/secure/InsertCollectorHelp!default.jspa?projectKey=" + TextUtils.htmlEncode((String)this.getProjectKey()) + "&collectorId=" + createdCollectorId);
            }
            Collector oldCollector = (Collector)this.collectorService.getCollector(this.collectorId).getReturnedValue();
            this.collectorService.updateCollector(this.collectorId, collectorData);
            if (this.triggerSignificantChange(oldCollector, (Collector)collectorData.getReturnedValue())) {
                return this.getRedirect("/secure/ViewCollectors!default.jspa?projectKey=" + TextUtils.htmlEncode((String)this.getProjectKey()) + "&updatedCollectorId=" + this.collectorId + "&triggerChanged=true");
            }
            return this.getRedirect("/secure/ViewCollectors!default.jspa?projectKey=" + TextUtils.htmlEncode((String)this.getProjectKey()) + "&updatedCollectorId=" + this.collectorId);
        }
        return "error";
    }

    private boolean triggerSignificantChange(Collector oldCollector, Collector newCollector) {
        if (!oldCollector.getTrigger().getPosition().equals((Object)Trigger.Position.CUSTOM) && newCollector.getTrigger().getPosition().equals((Object)Trigger.Position.CUSTOM)) {
            return true;
        }
        return oldCollector.getTrigger().getPosition().equals((Object)Trigger.Position.CUSTOM) && !newCollector.getTrigger().getPosition().equals((Object)Trigger.Position.CUSTOM);
    }

    private List<String> getCustomTemplateFieldList() {
        ArrayList<String> customFields = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.customTemplateFields)) {
            LinkedHashSet<String> internal = new LinkedHashSet<String>();
            try {
                JSONArray array = new JSONArray(this.customTemplateFields);
                for (int i = 0; i < array.length(); ++i) {
                    internal.add(array.getString(i));
                }
            }
            catch (JSONException e) {
                this.addErrorMessage("Invalid JSON array '" + this.customTemplateFields + "'");
            }
            customFields.addAll(internal);
        }
        return customFields;
    }

    public String getIssueTypeHtml() {
        HashMap<String, String> displayParams = new HashMap<String, String>();
        displayParams.put("theme", "aui");
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectId(this.getPid());
        Field field = this.getField("issuetype");
        Map values = this.issuetype != null ? Collections.singletonMap(field.getId(), this.issuetype.toString()) : Collections.emptyMap();
        OperationContextImpl operationContext = new OperationContextImpl((IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION, values);
        return ((OrderableField)field).getCreateHtml(null, (OperationContext)operationContext, (Action)this, (Issue)issue, displayParams);
    }

    public Long getIssuetype() {
        return this.issuetype;
    }

    public void setIssuetype(Long issuetype) {
        this.issuetype = issuetype;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public ApplicationUser getReporterUser() {
        return UserUtils.getUser((String)this.reporter);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isRecordWebInfo() {
        return this.recordWebInfo;
    }

    public void setRecordWebInfo(boolean recordWebInfo) {
        this.recordWebInfo = recordWebInfo;
    }

    public boolean isUseCredentials() {
        return this.useCredentials;
    }

    public void setUseCredentials(boolean useCredentials) {
        this.useCredentials = useCredentials;
    }

    public String getTriggerText() {
        return this.triggerText;
    }

    public void setTriggerText(String triggerText) {
        this.triggerText = triggerText;
    }

    public String getTriggerPosition() {
        return this.triggerPosition;
    }

    public void setTriggerPosition(String triggerPosition) {
        this.triggerPosition = triggerPosition;
    }

    public String getCustomFunction() {
        return this.customFunction;
    }

    public void setCustomFunction(String customFunction) {
        this.customFunction = customFunction;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public boolean canPerformAjaxSearch() {
        return this.searchService.canPerformAjaxSearch(this.getJiraServiceContext());
    }

    public List<Template> getCollectorTemplates() {
        return this.templateStore.getTemplates();
    }

    public boolean isPublicProject() {
        return this.permissionManager.hasPermission(10, this.getProject(), null);
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    public void setCustomMessage(String customMessage) {
        this.customMessage = customMessage;
    }

    public String getCustomTemplateFields() {
        return this.customTemplateFields;
    }

    public void setCustomTemplateFields(String customTemplateFields) {
        this.customTemplateFields = customTemplateFields;
    }

    public Long getPid() {
        Project project = this.getProject();
        return project == null ? null : project.getId();
    }

    private void updateCheckboxes() {
        if (!ActionContext.getParameters().containsKey("recordWebInfo")) {
            this.recordWebInfo = false;
        }
        if (!ActionContext.getParameters().containsKey("useCredentials")) {
            this.useCredentials = false;
        }
    }

    public String getCustomTemplateTitle() {
        return this.customTemplateTitle;
    }

    public void setCustomTemplateTitle(String customTemplateTitle) {
        this.customTemplateTitle = customTemplateTitle;
    }

    public String getCustomTemplateLabels() {
        return this.customTemplateLabels;
    }

    public void setCustomTemplateLabels(String customTemplateLabels) {
        this.customTemplateLabels = customTemplateLabels;
    }

    public String getMissingFieldPerIssueType() {
        try {
            return new ObjectMapper().writeValueAsString(this.missingFieldsChecker.getIssueTypeToMissingFieldsMapping(this.getProject()));
        }
        catch (IOException e) {
            return "";
        }
    }

    public String getRequiredInvalidFields() {
        try {
            return new ObjectMapper().writeValueAsString(this.collectorFieldValidator.getRequiredInvalidFieldsForProject(this.getLoggedInUser(), this.getProject()));
        }
        catch (IOException e) {
            return "";
        }
    }

    public String getCollectorId() {
        return this.collectorId;
    }

    public void setCollectorId(String collectorId) {
        this.collectorId = collectorId;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public String getReporterHtml() {
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectId(this.getPid());
        ImmutableMap<String, String> displayParams = ImmutableMap.of("theme", "aui");
        OrderableField reporterField = this.fieldManager.getOrderableField("reporter");
        Map values = this.reporter != null ? Collections.singletonMap(reporterField.getId(), this.reporter) : Collections.emptyMap();
        OperationContextImpl operationContext = new OperationContextImpl((IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION, values);
        FieldLayoutItem originalLayoutItem = this.fieldLayoutManager.getFieldLayout(this.getProject(), null).getFieldLayoutItem(reporterField);
        FieldLayoutItemWithCustomDescription customizedLayoutItem = new FieldLayoutItemWithCustomDescription(originalLayoutItem, this.getText("collector.plugin.admin.collector.reporter.desc"));
        return reporterField.getCreateHtml((FieldLayoutItem)customizedLayoutItem, (OperationContext)operationContext, (Action)this, (Issue)issue, displayParams);
    }

    private static class FieldLayoutItemWithCustomDescription
    implements FieldLayoutItem {
        private final FieldLayoutItem item;
        private final String fieldDescription;

        private FieldLayoutItemWithCustomDescription(FieldLayoutItem item, String fieldDescription) {
            this.item = item;
            this.fieldDescription = fieldDescription;
        }

        public int compareTo(FieldLayoutItem o) {
            return this.item.compareTo((Object)o);
        }

        public OrderableField getOrderableField() {
            return this.item.getOrderableField();
        }

        public String getFieldDescription() {
            return this.fieldDescription;
        }

        public String getRawFieldDescription() {
            return this.fieldDescription;
        }

        public boolean isHidden() {
            return this.item.isHidden();
        }

        public boolean isRequired() {
            return this.item.isRequired();
        }

        public String getRendererType() {
            return this.item.getRendererType();
        }

        public FieldLayout getFieldLayout() {
            return this.item.getFieldLayout();
        }
    }
}

